@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
 */
public data class FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs(
    public val destination: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs =
        com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs].
 */
@PulumiTagMarker
public class FunctionAsyncInvokeConfigDestinationConfigOnFailureArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    /**
     * @param value Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
     */
    @JvmName("sitdjrcmblrtdxfm")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
     */
    @JvmName("fompshkclutfokhl")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    internal fun build(): FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs =
        FunctionAsyncInvokeConfigDestinationConfigOnFailureArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
        )
}
