@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property destination Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
 */
public data class FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs(
    public val destination: Output<String>,
) :
    ConvertibleToJava<com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs =
        com.pulumi.alicloud.fc.inputs.FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs.builder()
            .destination(destination.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs].
 */
@PulumiTagMarker
public class FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgsBuilder internal constructor() {
    private var destination: Output<String>? = null

    /**
     * @param value Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
     */
    @JvmName("rawmfgdjyconmgcm")
    public suspend fun destination(`value`: Output<String>) {
        this.destination = value
    }

    /**
     * @param value Alicloud Resource Name (ARN) of the destination resource. See the [Developer Guide](https://www.alibabacloud.com/help/doc-detail/181866.htm) for acceptable resource types and associated RAM permissions.
     */
    @JvmName("kuimgrkkttkpohyn")
    public suspend fun destination(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destination = mapped
    }

    internal fun build(): FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs =
        FunctionAsyncInvokeConfigDestinationConfigOnSuccessArgs(
            destination = destination ?: throw PulumiNullFieldException("destination"),
        )
}
