@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.FunctionCustomContainerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property args The args field specifies the arguments passed to the command.
 * @property command The entry point of the container, which specifies the actual command run by the container.
 * @property image The container image address.
 */
public data class FunctionCustomContainerConfigArgs(
    public val args: Output<String>? = null,
    public val command: Output<String>? = null,
    public val image: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.FunctionCustomContainerConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.FunctionCustomContainerConfigArgs =
        com.pulumi.alicloud.fc.inputs.FunctionCustomContainerConfigArgs.builder()
            .args(args?.applyValue({ args0 -> args0 }))
            .command(command?.applyValue({ args0 -> args0 }))
            .image(image.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FunctionCustomContainerConfigArgs].
 */
@PulumiTagMarker
public class FunctionCustomContainerConfigArgsBuilder internal constructor() {
    private var args: Output<String>? = null

    private var command: Output<String>? = null

    private var image: Output<String>? = null

    /**
     * @param value The args field specifies the arguments passed to the command.
     */
    @JvmName("qybfrponsrpiyyeb")
    public suspend fun args(`value`: Output<String>) {
        this.args = value
    }

    /**
     * @param value The entry point of the container, which specifies the actual command run by the container.
     */
    @JvmName("qshmrnmjkicnevod")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value The container image address.
     */
    @JvmName("dvdlmaesrrhpvmlw")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The args field specifies the arguments passed to the command.
     */
    @JvmName("aoybfqurmadnvryy")
    public suspend fun args(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value The entry point of the container, which specifies the actual command run by the container.
     */
    @JvmName("skiwcjuhqhdmvedw")
    public suspend fun command(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value The container image address.
     */
    @JvmName("mvpojlfpsfhapmuu")
    public suspend fun image(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.image = mapped
    }

    internal fun build(): FunctionCustomContainerConfigArgs = FunctionCustomContainerConfigArgs(
        args = args,
        command = command,
        image = image ?: throw PulumiNullFieldException("image"),
    )
}
