@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.GetFunctionsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFunctions.
 * @property ids A list of functions ids.
 * @property nameRegex A regex string to filter results by function name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceName Name of the service that contains the functions to find.
 */
public data class GetFunctionsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.GetFunctionsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.GetFunctionsPlainArgs =
        com.pulumi.alicloud.fc.inputs.GetFunctionsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFunctionsPlainArgs].
 */
@PulumiTagMarker
public class GetFunctionsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var serviceName: String? = null

    /**
     * @param value A list of functions ids.
     */
    @JvmName("tttnaljgmyeeqgiy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of functions ids.
     */
    @JvmName("krinenouflfwyafy")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by function name.
     */
    @JvmName("mtpncrgaoowgmaes")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("rfpaufsxpjimyyru")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Name of the service that contains the functions to find.
     */
    @JvmName("dkpnjcfluxgttqsf")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetFunctionsPlainArgs = GetFunctionsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
