@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.GetTriggersPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTriggers.
 * @property functionName FC function name.
 * @property ids A list of FC triggers ids.
 * @property nameRegex A regex string to filter results by FC trigger name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property serviceName FC service name.
 */
public data class GetTriggersPlainArgs(
    public val functionName: String,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val serviceName: String,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.GetTriggersPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.GetTriggersPlainArgs =
        com.pulumi.alicloud.fc.inputs.GetTriggersPlainArgs.builder()
            .functionName(functionName.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .serviceName(serviceName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTriggersPlainArgs].
 */
@PulumiTagMarker
public class GetTriggersPlainArgsBuilder internal constructor() {
    private var functionName: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var serviceName: String? = null

    /**
     * @param value FC function name.
     */
    @JvmName("mwfxqpkbxdtigpei")
    public suspend fun functionName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.functionName = mapped
    }

    /**
     * @param value A list of FC triggers ids.
     */
    @JvmName("geqdcvkahkvdxhae")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of FC triggers ids.
     */
    @JvmName("mcfwalbvruecavks")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by FC trigger name.
     */
    @JvmName("mcefahqmljfyffmw")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("oleerpppymtkgabf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value FC service name.
     */
    @JvmName("mwsngccvuenfscfj")
    public suspend fun serviceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.serviceName = mapped
    }

    internal fun build(): GetTriggersPlainArgs = GetTriggersPlainArgs(
        functionName = functionName ?: throw PulumiNullFieldException("functionName"),
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
        serviceName = serviceName ?: throw PulumiNullFieldException("serviceName"),
    )
}
