@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.ServiceLogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableInstanceMetrics Enable instance level metrics.
 * @property enableRequestMetrics Enable request level metrics.
 * @property logstore The log store name of Alicloud Simple Log Service.
 * @property project The project name of the Alicloud Simple Log Service.
 */
public data class ServiceLogConfigArgs(
    public val enableInstanceMetrics: Output<Boolean>? = null,
    public val enableRequestMetrics: Output<Boolean>? = null,
    public val logstore: Output<String>,
    public val project: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.ServiceLogConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.ServiceLogConfigArgs =
        com.pulumi.alicloud.fc.inputs.ServiceLogConfigArgs.builder()
            .enableInstanceMetrics(enableInstanceMetrics?.applyValue({ args0 -> args0 }))
            .enableRequestMetrics(enableRequestMetrics?.applyValue({ args0 -> args0 }))
            .logstore(logstore.applyValue({ args0 -> args0 }))
            .project(project.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceLogConfigArgs].
 */
@PulumiTagMarker
public class ServiceLogConfigArgsBuilder internal constructor() {
    private var enableInstanceMetrics: Output<Boolean>? = null

    private var enableRequestMetrics: Output<Boolean>? = null

    private var logstore: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value Enable instance level metrics.
     */
    @JvmName("xpelqfyywcfiquvv")
    public suspend fun enableInstanceMetrics(`value`: Output<Boolean>) {
        this.enableInstanceMetrics = value
    }

    /**
     * @param value Enable request level metrics.
     */
    @JvmName("xqhgdytulelnvsms")
    public suspend fun enableRequestMetrics(`value`: Output<Boolean>) {
        this.enableRequestMetrics = value
    }

    /**
     * @param value The log store name of Alicloud Simple Log Service.
     */
    @JvmName("slhxjtgopdafqiod")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The project name of the Alicloud Simple Log Service.
     */
    @JvmName("wuuokpypbsbvykmo")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value Enable instance level metrics.
     */
    @JvmName("gwwejegmuwoxugfk")
    public suspend fun enableInstanceMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInstanceMetrics = mapped
    }

    /**
     * @param value Enable request level metrics.
     */
    @JvmName("yfoocxnroxvhcycp")
    public suspend fun enableRequestMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRequestMetrics = mapped
    }

    /**
     * @param value The log store name of Alicloud Simple Log Service.
     */
    @JvmName("evvxiwjuimritlag")
    public suspend fun logstore(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The project name of the Alicloud Simple Log Service.
     */
    @JvmName("ybqwpogwckqydcqb")
    public suspend fun project(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): ServiceLogConfigArgs = ServiceLogConfigArgs(
        enableInstanceMetrics = enableInstanceMetrics,
        enableRequestMetrics = enableRequestMetrics,
        logstore = logstore ?: throw PulumiNullFieldException("logstore"),
        project = project ?: throw PulumiNullFieldException("project"),
    )
}
