@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.ServiceNasConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groupId The group id of your NAS file system.
 * @property mountPoints Config the NAS mount points.See `mount_points` below.
 * @property userId The user id of your NAS file system.
 */
public data class ServiceNasConfigArgs(
    public val groupId: Output<Int>,
    public val mountPoints: Output<List<ServiceNasConfigMountPointArgs>>,
    public val userId: Output<Int>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.ServiceNasConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.ServiceNasConfigArgs =
        com.pulumi.alicloud.fc.inputs.ServiceNasConfigArgs.builder()
            .groupId(groupId.applyValue({ args0 -> args0 }))
            .mountPoints(
                mountPoints.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userId(userId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNasConfigArgs].
 */
@PulumiTagMarker
public class ServiceNasConfigArgsBuilder internal constructor() {
    private var groupId: Output<Int>? = null

    private var mountPoints: Output<List<ServiceNasConfigMountPointArgs>>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value The group id of your NAS file system.
     */
    @JvmName("kymrybvmmvfkxqvs")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("jvlbwhnlifqvviff")
    public suspend fun mountPoints(`value`: Output<List<ServiceNasConfigMountPointArgs>>) {
        this.mountPoints = value
    }

    @JvmName("dqbnfqordhyrbtvq")
    public suspend fun mountPoints(vararg values: Output<ServiceNasConfigMountPointArgs>) {
        this.mountPoints = Output.all(values.asList())
    }

    /**
     * @param values Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("vqkllffqvigvkhwv")
    public suspend fun mountPoints(values: List<Output<ServiceNasConfigMountPointArgs>>) {
        this.mountPoints = Output.all(values)
    }

    /**
     * @param value The user id of your NAS file system.
     */
    @JvmName("nswjatdnqiaoqypi")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value The group id of your NAS file system.
     */
    @JvmName("jxudqhmjvtytjmga")
    public suspend fun groupId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("ixcjvearkymbgdfr")
    public suspend fun mountPoints(`value`: List<ServiceNasConfigMountPointArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    /**
     * @param argument Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("gyeuwvshkfneisat")
    public suspend fun mountPoints(argument: List<suspend ServiceNasConfigMountPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ServiceNasConfigMountPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("eagfjsekxsotuypw")
    public suspend fun mountPoints(vararg argument: suspend ServiceNasConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ServiceNasConfigMountPointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("mtoljyurlivupbda")
    public suspend fun mountPoints(argument: suspend ServiceNasConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ServiceNasConfigMountPointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param values Config the NAS mount points.See `mount_points` below.
     */
    @JvmName("mcnkycoaqmaxqqeu")
    public suspend fun mountPoints(vararg values: ServiceNasConfigMountPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    /**
     * @param value The user id of your NAS file system.
     */
    @JvmName("pggepioxbyyjocoq")
    public suspend fun userId(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): ServiceNasConfigArgs = ServiceNasConfigArgs(
        groupId = groupId ?: throw PulumiNullFieldException("groupId"),
        mountPoints = mountPoints ?: throw PulumiNullFieldException("mountPoints"),
        userId = userId ?: throw PulumiNullFieldException("userId"),
    )
}
