@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.ServiceNasConfigMountPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property mountDir The local address where to mount your remote NAS directory.
 * @property serverAddr The address of the remote NAS directory.
 */
public data class ServiceNasConfigMountPointArgs(
    public val mountDir: Output<String>,
    public val serverAddr: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.ServiceNasConfigMountPointArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.ServiceNasConfigMountPointArgs =
        com.pulumi.alicloud.fc.inputs.ServiceNasConfigMountPointArgs.builder()
            .mountDir(mountDir.applyValue({ args0 -> args0 }))
            .serverAddr(serverAddr.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceNasConfigMountPointArgs].
 */
@PulumiTagMarker
public class ServiceNasConfigMountPointArgsBuilder internal constructor() {
    private var mountDir: Output<String>? = null

    private var serverAddr: Output<String>? = null

    /**
     * @param value The local address where to mount your remote NAS directory.
     */
    @JvmName("axfoqholbuuniiuw")
    public suspend fun mountDir(`value`: Output<String>) {
        this.mountDir = value
    }

    /**
     * @param value The address of the remote NAS directory.
     */
    @JvmName("yamqrdmylvbqomtv")
    public suspend fun serverAddr(`value`: Output<String>) {
        this.serverAddr = value
    }

    /**
     * @param value The local address where to mount your remote NAS directory.
     */
    @JvmName("jbaocfayfcoaccak")
    public suspend fun mountDir(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountDir = mapped
    }

    /**
     * @param value The address of the remote NAS directory.
     */
    @JvmName("twxswvisxhyhygwf")
    public suspend fun serverAddr(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverAddr = mapped
    }

    internal fun build(): ServiceNasConfigMountPointArgs = ServiceNasConfigMountPointArgs(
        mountDir = mountDir ?: throw PulumiNullFieldException("mountDir"),
        serverAddr = serverAddr ?: throw PulumiNullFieldException("serverAddr"),
    )
}
