@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.ServiceTracingConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property params Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
 * @property type Tracing protocol type. Currently, only Jaeger is supported.
 */
public data class ServiceTracingConfigArgs(
    public val params: Output<Map<String, String>>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.ServiceTracingConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.ServiceTracingConfigArgs =
        com.pulumi.alicloud.fc.inputs.ServiceTracingConfigArgs.builder()
            .params(params.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceTracingConfigArgs].
 */
@PulumiTagMarker
public class ServiceTracingConfigArgsBuilder internal constructor() {
    private var params: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
     */
    @JvmName("yaqdvgpwycfbrovi")
    public suspend fun params(`value`: Output<Map<String, String>>) {
        this.params = value
    }

    /**
     * @param value Tracing protocol type. Currently, only Jaeger is supported.
     */
    @JvmName("fnllkjbngtugifie")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
     */
    @JvmName("dtxuqshgmywxvofh")
    public suspend fun params(`value`: Map<String, String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.params = mapped
    }

    /**
     * @param values Tracing parameters, which type is map[string]string. When the protocol type is Jaeger, the key is "endpoint" and the value is your tracing intranet endpoint. For example endpoint: http://tracing-analysis-dc-hz.aliyuncs.com/adapt_xxx/api/traces.
     */
    @JvmName("cycadeusthhabmwa")
    public fun params(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.params = mapped
    }

    /**
     * @param value Tracing protocol type. Currently, only Jaeger is supported.
     */
    @JvmName("traehksmaedmyvre")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ServiceTracingConfigArgs = ServiceTracingConfigArgs(
        params = params ?: throw PulumiNullFieldException("params"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
