@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.ServiceVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupId A security group ID associated with the Function Compute Service.
 * @property vpcId A vpc ID associated with the Function Compute Service.
 * @property vswitchIds A list of vswitch IDs associated with the Function Compute Service.
 */
public data class ServiceVpcConfigArgs(
    public val securityGroupId: Output<String>,
    public val vpcId: Output<String>? = null,
    public val vswitchIds: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.ServiceVpcConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.ServiceVpcConfigArgs =
        com.pulumi.alicloud.fc.inputs.ServiceVpcConfigArgs.builder()
            .securityGroupId(securityGroupId.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ServiceVpcConfigArgs].
 */
@PulumiTagMarker
public class ServiceVpcConfigArgsBuilder internal constructor() {
    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value A security group ID associated with the Function Compute Service.
     */
    @JvmName("obqeruesstdiudqg")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value A vpc ID associated with the Function Compute Service.
     */
    @JvmName("elnfrbecsskmbmvq")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value A list of vswitch IDs associated with the Function Compute Service.
     */
    @JvmName("gisekuavtwguhcbc")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("qkfcuwcseokxtafw")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values A list of vswitch IDs associated with the Function Compute Service.
     */
    @JvmName("fhqujrdkjjkjrdpi")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value A security group ID associated with the Function Compute Service.
     */
    @JvmName("ckcspngdaewdsrcf")
    public suspend fun securityGroupId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value A vpc ID associated with the Function Compute Service.
     */
    @JvmName("yidhujaymrrgcwpe")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value A list of vswitch IDs associated with the Function Compute Service.
     */
    @JvmName("fbyvjcuatvqindni")
    public suspend fun vswitchIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values A list of vswitch IDs associated with the Function Compute Service.
     */
    @JvmName("fsnvwylksxtkkdbm")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): ServiceVpcConfigArgs = ServiceVpcConfigArgs(
        securityGroupId = securityGroupId ?: throw PulumiNullFieldException("securityGroupId"),
        vpcId = vpcId,
        vswitchIds = vswitchIds ?: throw PulumiNullFieldException("vswitchIds"),
    )
}
