@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property ossBucketName The OSS bucket name of the function code package.
 * @property ossObjectName The OSS object name of the function code package.
 * @property zipFile Upload the base64 encoding of the code zip package directly in the request body.
 */
public data class V2FunctionCodeArgs(
    public val ossBucketName: Output<String>? = null,
    public val ossObjectName: Output<String>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCodeArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCodeArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCodeArgs.builder()
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossObjectName(ossObjectName?.applyValue({ args0 -> args0 }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionCodeArgs].
 */
@PulumiTagMarker
public class V2FunctionCodeArgsBuilder internal constructor() {
    private var ossBucketName: Output<String>? = null

    private var ossObjectName: Output<String>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value The OSS bucket name of the function code package.
     */
    @JvmName("ylfnjkamaljkncwe")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value The OSS object name of the function code package.
     */
    @JvmName("wvhnsaxhknoocqif")
    public suspend fun ossObjectName(`value`: Output<String>) {
        this.ossObjectName = value
    }

    /**
     * @param value Upload the base64 encoding of the code zip package directly in the request body.
     */
    @JvmName("lpgkohhofrwtnjkf")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value The OSS bucket name of the function code package.
     */
    @JvmName("yjhylacedbywlfuo")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value The OSS object name of the function code package.
     */
    @JvmName("lnpibpbwpmfivpxd")
    public suspend fun ossObjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossObjectName = mapped
    }

    /**
     * @param value Upload the base64 encoding of the code zip package directly in the request body.
     */
    @JvmName("pqlfrnirrffqbvca")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): V2FunctionCodeArgs = V2FunctionCodeArgs(
        ossBucketName = ossBucketName,
        ossObjectName = ossObjectName,
        zipFile = zipFile,
    )
}
