@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCustomContainerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accelerationType Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
 * @property args Container startup parameters.
 * @property command Container start command, equivalent to Docker ENTRYPOINT.
 * @property image Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
 * @property webServerMode Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
 */
public data class V2FunctionCustomContainerConfigArgs(
    public val accelerationType: Output<String>? = null,
    public val args: Output<String>? = null,
    public val command: Output<String>? = null,
    public val image: Output<String>? = null,
    public val webServerMode: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCustomContainerConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCustomContainerConfigArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCustomContainerConfigArgs.builder()
            .accelerationType(accelerationType?.applyValue({ args0 -> args0 }))
            .args(args?.applyValue({ args0 -> args0 }))
            .command(command?.applyValue({ args0 -> args0 }))
            .image(image?.applyValue({ args0 -> args0 }))
            .webServerMode(webServerMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionCustomContainerConfigArgs].
 */
@PulumiTagMarker
public class V2FunctionCustomContainerConfigArgsBuilder internal constructor() {
    private var accelerationType: Output<String>? = null

    private var args: Output<String>? = null

    private var command: Output<String>? = null

    private var image: Output<String>? = null

    private var webServerMode: Output<Boolean>? = null

    /**
     * @param value Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
     */
    @JvmName("bjofoxpbpbghtqak")
    public suspend fun accelerationType(`value`: Output<String>) {
        this.accelerationType = value
    }

    /**
     * @param value Container startup parameters.
     */
    @JvmName("toewrwnacywiyaba")
    public suspend fun args(`value`: Output<String>) {
        this.args = value
    }

    /**
     * @param value Container start command, equivalent to Docker ENTRYPOINT.
     */
    @JvmName("hmsvsuptxmwdlsuk")
    public suspend fun command(`value`: Output<String>) {
        this.command = value
    }

    /**
     * @param value Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
     */
    @JvmName("jjvohoobpyyeixlx")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
     */
    @JvmName("jbkssjvurgnogfje")
    public suspend fun webServerMode(`value`: Output<Boolean>) {
        this.webServerMode = value
    }

    /**
     * @param value Image acceleration type. The value Default is to enable acceleration and None is to disable acceleration.
     */
    @JvmName("fhadfbbjmxvkmypp")
    public suspend fun accelerationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerationType = mapped
    }

    /**
     * @param value Container startup parameters.
     */
    @JvmName("xphmjryrgdxuwrnu")
    public suspend fun args(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Container start command, equivalent to Docker ENTRYPOINT.
     */
    @JvmName("endbqhspxguphgog")
    public suspend fun command(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Container Image address. Example value: registry-vpc.cn-hangzhou.aliyuncs.com/fc-demo/helloworld:v1beta1.
     */
    @JvmName("exgyfhlfvyuwcpwr")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value Whether the image is run in Web Server mode. The value of true needs to implement the Web Server in the container image to listen to the port and process the request. The value of false needs to actively exit the process after the container runs, and the ExitCode needs to be 0. Default true.
     */
    @JvmName("gvxwfxvubhlqhobe")
    public suspend fun webServerMode(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webServerMode = mapped
    }

    internal fun build(): V2FunctionCustomContainerConfigArgs = V2FunctionCustomContainerConfigArgs(
        accelerationType = accelerationType,
        args = args,
        command = command,
        image = image,
        webServerMode = webServerMode,
    )
}
