@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsOptions DNS resolver configuration parameter list. See `dns_options` below.
 * @property nameServers List of IP addresses of DNS servers.
 * @property searches List of DNS search domains.
 */
public data class V2FunctionCustomDnsArgs(
    public val dnsOptions: Output<List<V2FunctionCustomDnsDnsOptionArgs>>? = null,
    public val nameServers: Output<List<String>>? = null,
    public val searches: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsArgs.builder()
            .dnsOptions(
                dnsOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nameServers(nameServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .searches(searches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [V2FunctionCustomDnsArgs].
 */
@PulumiTagMarker
public class V2FunctionCustomDnsArgsBuilder internal constructor() {
    private var dnsOptions: Output<List<V2FunctionCustomDnsDnsOptionArgs>>? = null

    private var nameServers: Output<List<String>>? = null

    private var searches: Output<List<String>>? = null

    /**
     * @param value DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("gbblknubsptrqtlx")
    public suspend fun dnsOptions(`value`: Output<List<V2FunctionCustomDnsDnsOptionArgs>>) {
        this.dnsOptions = value
    }

    @JvmName("rxbvyseortemyske")
    public suspend fun dnsOptions(vararg values: Output<V2FunctionCustomDnsDnsOptionArgs>) {
        this.dnsOptions = Output.all(values.asList())
    }

    /**
     * @param values DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("aeyjomcpxvqrpqjq")
    public suspend fun dnsOptions(values: List<Output<V2FunctionCustomDnsDnsOptionArgs>>) {
        this.dnsOptions = Output.all(values)
    }

    /**
     * @param value List of IP addresses of DNS servers.
     */
    @JvmName("pdpaqbbwddtisktq")
    public suspend fun nameServers(`value`: Output<List<String>>) {
        this.nameServers = value
    }

    @JvmName("premwiuvmashagvs")
    public suspend fun nameServers(vararg values: Output<String>) {
        this.nameServers = Output.all(values.asList())
    }

    /**
     * @param values List of IP addresses of DNS servers.
     */
    @JvmName("vagxbduoqttpjrpv")
    public suspend fun nameServers(values: List<Output<String>>) {
        this.nameServers = Output.all(values)
    }

    /**
     * @param value List of DNS search domains.
     */
    @JvmName("pxbbiqmhtavypfmh")
    public suspend fun searches(`value`: Output<List<String>>) {
        this.searches = value
    }

    @JvmName("pojbduxylxrrdkvh")
    public suspend fun searches(vararg values: Output<String>) {
        this.searches = Output.all(values.asList())
    }

    /**
     * @param values List of DNS search domains.
     */
    @JvmName("fwdlhhhuxlpwlhyr")
    public suspend fun searches(values: List<Output<String>>) {
        this.searches = Output.all(values)
    }

    /**
     * @param value DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("lvkpjfjoosbkkurr")
    public suspend fun dnsOptions(`value`: List<V2FunctionCustomDnsDnsOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsOptions = mapped
    }

    /**
     * @param argument DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("kqmqjviandtsldvb")
    public suspend fun dnsOptions(argument: List<suspend V2FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V2FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param argument DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("ljyhsokxbmycqkvu")
    public suspend fun dnsOptions(vararg argument: suspend V2FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V2FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param argument DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("imdmxntwtdtodbqw")
    public suspend fun dnsOptions(argument: suspend V2FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V2FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param values DNS resolver configuration parameter list. See `dns_options` below.
     */
    @JvmName("kfolnujxcjsvnpdf")
    public suspend fun dnsOptions(vararg values: V2FunctionCustomDnsDnsOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsOptions = mapped
    }

    /**
     * @param value List of IP addresses of DNS servers.
     */
    @JvmName("bvnyvjxshwhvodic")
    public suspend fun nameServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param values List of IP addresses of DNS servers.
     */
    @JvmName("hxsgcglppgvkhyos")
    public suspend fun nameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param value List of DNS search domains.
     */
    @JvmName("ctsqxuaegtqlddkh")
    public suspend fun searches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    /**
     * @param values List of DNS search domains.
     */
    @JvmName("hsrrtnismomhlvwy")
    public suspend fun searches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    internal fun build(): V2FunctionCustomDnsArgs = V2FunctionCustomDnsArgs(
        dnsOptions = dnsOptions,
        nameServers = nameServers,
        searches = searches,
    )
}
