@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsDnsOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name DNS option name.
 * @property value DNS option value.
 */
public data class V2FunctionCustomDnsDnsOptionArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsDnsOptionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsDnsOptionArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCustomDnsDnsOptionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionCustomDnsDnsOptionArgs].
 */
@PulumiTagMarker
public class V2FunctionCustomDnsDnsOptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value DNS option name.
     */
    @JvmName("loexlsscwofexkeg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value DNS option value.
     */
    @JvmName("tjcvwjqogwcfpfyb")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value DNS option name.
     */
    @JvmName("fobhrdbsdnhytahv")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value DNS option value.
     */
    @JvmName("ormoscclbabfqalp")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): V2FunctionCustomDnsDnsOptionArgs = V2FunctionCustomDnsDnsOptionArgs(
        name = name,
        `value` = `value`,
    )
}
