@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCustomHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failureThreshold The threshold for the number of health check failures. The system considers the check failed after the health check fails.
 * @property httpGetUrl Container custom health check URL address.
 * @property initialDelaySeconds Delay from container startup to initiation of health check.
 * @property periodSeconds Health check cycle.
 * @property successThreshold The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
 * @property timeoutSeconds Health check timeout.
 */
public data class V2FunctionCustomHealthCheckConfigArgs(
    public val failureThreshold: Output<Int>? = null,
    public val httpGetUrl: Output<String>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCustomHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCustomHealthCheckConfigArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCustomHealthCheckConfigArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGetUrl(httpGetUrl?.applyValue({ args0 -> args0 }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionCustomHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class V2FunctionCustomHealthCheckConfigArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    private var httpGetUrl: Output<String>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value The threshold for the number of health check failures. The system considers the check failed after the health check fails.
     */
    @JvmName("xntorlkhjqumnqym")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value Container custom health check URL address.
     */
    @JvmName("tpoatwgwmduwmgof")
    public suspend fun httpGetUrl(`value`: Output<String>) {
        this.httpGetUrl = value
    }

    /**
     * @param value Delay from container startup to initiation of health check.
     */
    @JvmName("mactrwcxugcgwxgu")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value Health check cycle.
     */
    @JvmName("iboepynipyxjkspd")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
     */
    @JvmName("ipytpdflaxutthpd")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value Health check timeout.
     */
    @JvmName("xiodnasqgpakiisv")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value The threshold for the number of health check failures. The system considers the check failed after the health check fails.
     */
    @JvmName("usglyfoivplgqlfm")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value Container custom health check URL address.
     */
    @JvmName("thpoikxvyiqsnmhg")
    public suspend fun httpGetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGetUrl = mapped
    }

    /**
     * @param value Delay from container startup to initiation of health check.
     */
    @JvmName("tiiqhicbjvvqwegb")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value Health check cycle.
     */
    @JvmName("yqkjeryautafpipt")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value The threshold for the number of successful health checks. After the health check is reached, the system considers the check successful.
     */
    @JvmName("akiwwkiryaiqiwhy")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value Health check timeout.
     */
    @JvmName("hjpkbixjaiignxme")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): V2FunctionCustomHealthCheckConfigArgs =
        V2FunctionCustomHealthCheckConfigArgs(
            failureThreshold = failureThreshold,
            httpGetUrl = httpGetUrl,
            initialDelaySeconds = initialDelaySeconds,
            periodSeconds = periodSeconds,
            successThreshold = successThreshold,
            timeoutSeconds = timeoutSeconds,
        )
}
