@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionCustomRuntimeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args Parameters received by the start entry command.
 * @property commands List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
 */
public data class V2FunctionCustomRuntimeConfigArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionCustomRuntimeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionCustomRuntimeConfigArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionCustomRuntimeConfigArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [V2FunctionCustomRuntimeConfigArgs].
 */
@PulumiTagMarker
public class V2FunctionCustomRuntimeConfigArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    /**
     * @param value Parameters received by the start entry command.
     */
    @JvmName("belgswqgljhyjkry")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("cyhcmerjkoccbymx")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Parameters received by the start entry command.
     */
    @JvmName("gttgvgavcqwfjuir")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
     */
    @JvmName("kfcngokicrmwlaia")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("atwwkoqeumrvljqw")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
     */
    @JvmName("lrkkwmiokxfqltry")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Parameters received by the start entry command.
     */
    @JvmName("dwigtwjcofapbwmx")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Parameters received by the start entry command.
     */
    @JvmName("onypecvpiacsncmc")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
     */
    @JvmName("jsbdwuwjfjawrhwd")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values List of Custom entry commands started by Custom Runtime. When there are multiple commands in the list, they are spliced in sequence.
     */
    @JvmName("wiwpskxbtbfpbxdg")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    internal fun build(): V2FunctionCustomRuntimeConfigArgs = V2FunctionCustomRuntimeConfigArgs(
        args = args,
        commands = commands,
    )
}
