@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property preFreeze PreFreeze function configuration. See `pre_freeze` below.
 * @property preStop PreStop function configuration. See `pre_stop` below.
 */
public data class V2FunctionInstanceLifecycleConfigArgs(
    public val preFreeze: Output<V2FunctionInstanceLifecycleConfigPreFreezeArgs>? = null,
    public val preStop: Output<V2FunctionInstanceLifecycleConfigPreStopArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigArgs.builder()
            .preFreeze(preFreeze?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preStop(preStop?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V2FunctionInstanceLifecycleConfigArgs].
 */
@PulumiTagMarker
public class V2FunctionInstanceLifecycleConfigArgsBuilder internal constructor() {
    private var preFreeze: Output<V2FunctionInstanceLifecycleConfigPreFreezeArgs>? = null

    private var preStop: Output<V2FunctionInstanceLifecycleConfigPreStopArgs>? = null

    /**
     * @param value PreFreeze function configuration. See `pre_freeze` below.
     */
    @JvmName("mfppjrsmesihcids")
    public suspend fun preFreeze(`value`: Output<V2FunctionInstanceLifecycleConfigPreFreezeArgs>) {
        this.preFreeze = value
    }

    /**
     * @param value PreStop function configuration. See `pre_stop` below.
     */
    @JvmName("xftorcjshbigrjjy")
    public suspend fun preStop(`value`: Output<V2FunctionInstanceLifecycleConfigPreStopArgs>) {
        this.preStop = value
    }

    /**
     * @param value PreFreeze function configuration. See `pre_freeze` below.
     */
    @JvmName("cvleiiakifkbprjt")
    public suspend fun preFreeze(`value`: V2FunctionInstanceLifecycleConfigPreFreezeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preFreeze = mapped
    }

    /**
     * @param argument PreFreeze function configuration. See `pre_freeze` below.
     */
    @JvmName("lmjgevhpkqiktatl")
    public suspend fun preFreeze(argument: suspend V2FunctionInstanceLifecycleConfigPreFreezeArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionInstanceLifecycleConfigPreFreezeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.preFreeze = mapped
    }

    /**
     * @param value PreStop function configuration. See `pre_stop` below.
     */
    @JvmName("howjlhwbskbtdlwq")
    public suspend fun preStop(`value`: V2FunctionInstanceLifecycleConfigPreStopArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preStop = mapped
    }

    /**
     * @param argument PreStop function configuration. See `pre_stop` below.
     */
    @JvmName("rxrdxpxvxsifxwjm")
    public suspend fun preStop(argument: suspend V2FunctionInstanceLifecycleConfigPreStopArgsBuilder.() -> Unit) {
        val toBeMapped = V2FunctionInstanceLifecycleConfigPreStopArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.preStop = mapped
    }

    internal fun build(): V2FunctionInstanceLifecycleConfigArgs =
        V2FunctionInstanceLifecycleConfigArgs(
            preFreeze = preFreeze,
            preStop = preStop,
        )
}
