@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigPreFreezeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property handler entry point of function.
 * @property timeout max running time of function.
 */
public data class V2FunctionInstanceLifecycleConfigPreFreezeArgs(
    public val handler: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigPreFreezeArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigPreFreezeArgs =
        com.pulumi.alicloud.fc.inputs.V2FunctionInstanceLifecycleConfigPreFreezeArgs.builder()
            .handler(handler?.applyValue({ args0 -> args0 }))
            .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V2FunctionInstanceLifecycleConfigPreFreezeArgs].
 */
@PulumiTagMarker
public class V2FunctionInstanceLifecycleConfigPreFreezeArgsBuilder internal constructor() {
    private var handler: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value entry point of function.
     */
    @JvmName("aupuhrjicsepdwwj")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value max running time of function.
     */
    @JvmName("vuvhljgvjqdjdpnm")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value entry point of function.
     */
    @JvmName("qwsypqctpsuaangx")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value max running time of function.
     */
    @JvmName("sirwklgnlxkeaxnr")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): V2FunctionInstanceLifecycleConfigPreFreezeArgs =
        V2FunctionInstanceLifecycleConfigPreFreezeArgs(
            handler = handler,
            timeout = timeout,
        )
}
