@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3AsyncInvokeConfigDestinationConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property onFailure Failed callback target structure. See `on_failure` below.
 * @property onSuccess Successful callback target structure. See `on_success` below.
 */
public data class V3AsyncInvokeConfigDestinationConfigArgs(
    public val onFailure: Output<V3AsyncInvokeConfigDestinationConfigOnFailureArgs>? = null,
    public val onSuccess: Output<V3AsyncInvokeConfigDestinationConfigOnSuccessArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3AsyncInvokeConfigDestinationConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3AsyncInvokeConfigDestinationConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3AsyncInvokeConfigDestinationConfigArgs.builder()
            .onFailure(onFailure?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .onSuccess(onSuccess?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V3AsyncInvokeConfigDestinationConfigArgs].
 */
@PulumiTagMarker
public class V3AsyncInvokeConfigDestinationConfigArgsBuilder internal constructor() {
    private var onFailure: Output<V3AsyncInvokeConfigDestinationConfigOnFailureArgs>? = null

    private var onSuccess: Output<V3AsyncInvokeConfigDestinationConfigOnSuccessArgs>? = null

    /**
     * @param value Failed callback target structure. See `on_failure` below.
     */
    @JvmName("cwuvcwmklvfgxqpt")
    public suspend fun onFailure(`value`: Output<V3AsyncInvokeConfigDestinationConfigOnFailureArgs>) {
        this.onFailure = value
    }

    /**
     * @param value Successful callback target structure. See `on_success` below.
     */
    @JvmName("dvfidonsindvaiao")
    public suspend fun onSuccess(`value`: Output<V3AsyncInvokeConfigDestinationConfigOnSuccessArgs>) {
        this.onSuccess = value
    }

    /**
     * @param value Failed callback target structure. See `on_failure` below.
     */
    @JvmName("ygybeqekpobnsnwq")
    public suspend fun onFailure(`value`: V3AsyncInvokeConfigDestinationConfigOnFailureArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onFailure = mapped
    }

    /**
     * @param argument Failed callback target structure. See `on_failure` below.
     */
    @JvmName("rkpkhbvksbcjeoyb")
    public suspend fun onFailure(argument: suspend V3AsyncInvokeConfigDestinationConfigOnFailureArgsBuilder.() -> Unit) {
        val toBeMapped = V3AsyncInvokeConfigDestinationConfigOnFailureArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onFailure = mapped
    }

    /**
     * @param value Successful callback target structure. See `on_success` below.
     */
    @JvmName("ffpiiecuyffxvgdr")
    public suspend fun onSuccess(`value`: V3AsyncInvokeConfigDestinationConfigOnSuccessArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onSuccess = mapped
    }

    /**
     * @param argument Successful callback target structure. See `on_success` below.
     */
    @JvmName("psnoyslfgtacrqme")
    public suspend fun onSuccess(argument: suspend V3AsyncInvokeConfigDestinationConfigOnSuccessArgsBuilder.() -> Unit) {
        val toBeMapped = V3AsyncInvokeConfigDestinationConfigOnSuccessArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.onSuccess = mapped
    }

    internal fun build(): V3AsyncInvokeConfigDestinationConfigArgs =
        V3AsyncInvokeConfigDestinationConfigArgs(
            onFailure = onFailure,
            onSuccess = onSuccess,
        )
}
