@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainAuthConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authInfo Authentication Information.
 * @property authType Authentication type. anonymous, function, or jwt.
 */
public data class V3CustomDomainAuthConfigArgs(
    public val authInfo: Output<String>? = null,
    public val authType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainAuthConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainAuthConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainAuthConfigArgs.builder()
            .authInfo(authInfo?.applyValue({ args0 -> args0 }))
            .authType(authType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3CustomDomainAuthConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainAuthConfigArgsBuilder internal constructor() {
    private var authInfo: Output<String>? = null

    private var authType: Output<String>? = null

    /**
     * @param value Authentication Information.
     */
    @JvmName("lpkqjesgfvgnrgfg")
    public suspend fun authInfo(`value`: Output<String>) {
        this.authInfo = value
    }

    /**
     * @param value Authentication type. anonymous, function, or jwt.
     */
    @JvmName("cxxcrqqyfqlkkvdg")
    public suspend fun authType(`value`: Output<String>) {
        this.authType = value
    }

    /**
     * @param value Authentication Information.
     */
    @JvmName("aqfgokootrqfawmj")
    public suspend fun authInfo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authInfo = mapped
    }

    /**
     * @param value Authentication type. anonymous, function, or jwt.
     */
    @JvmName("byixegkwipouoxon")
    public suspend fun authType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authType = mapped
    }

    internal fun build(): V3CustomDomainAuthConfigArgs = V3CustomDomainAuthConfigArgs(
        authInfo = authInfo,
        authType = authType,
    )
}
