@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainCertConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property certName Certificate Name.
 * @property certificate PEM format certificate.
 * @property privateKey Private Key in PEM format.
 */
public data class V3CustomDomainCertConfigArgs(
    public val certName: Output<String>? = null,
    public val certificate: Output<String>? = null,
    public val privateKey: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainCertConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainCertConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainCertConfigArgs.builder()
            .certName(certName?.applyValue({ args0 -> args0 }))
            .certificate(certificate?.applyValue({ args0 -> args0 }))
            .privateKey(privateKey?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3CustomDomainCertConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainCertConfigArgsBuilder internal constructor() {
    private var certName: Output<String>? = null

    private var certificate: Output<String>? = null

    private var privateKey: Output<String>? = null

    /**
     * @param value Certificate Name.
     */
    @JvmName("aiaehevhowfueicm")
    public suspend fun certName(`value`: Output<String>) {
        this.certName = value
    }

    /**
     * @param value PEM format certificate.
     */
    @JvmName("gysesemertftqoal")
    public suspend fun certificate(`value`: Output<String>) {
        this.certificate = value
    }

    /**
     * @param value Private Key in PEM format.
     */
    @JvmName("iljwtdbkapgqbhly")
    public suspend fun privateKey(`value`: Output<String>) {
        this.privateKey = value
    }

    /**
     * @param value Certificate Name.
     */
    @JvmName("prilgktllttumjny")
    public suspend fun certName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certName = mapped
    }

    /**
     * @param value PEM format certificate.
     */
    @JvmName("umolpovlgsuuwkvy")
    public suspend fun certificate(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.certificate = mapped
    }

    /**
     * @param value Private Key in PEM format.
     */
    @JvmName("kjlakauibublwvdo")
    public suspend fun privateKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateKey = mapped
    }

    internal fun build(): V3CustomDomainCertConfigArgs = V3CustomDomainCertConfigArgs(
        certName = certName,
        certificate = certificate,
        privateKey = privateKey,
    )
}
