@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property routes Routing Configuration List. See `routes` below.
 */
public data class V3CustomDomainRouteConfigArgs(
    public val routes: Output<List<V3CustomDomainRouteConfigRouteArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigArgs.builder()
            .routes(
                routes?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V3CustomDomainRouteConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainRouteConfigArgsBuilder internal constructor() {
    private var routes: Output<List<V3CustomDomainRouteConfigRouteArgs>>? = null

    /**
     * @param value Routing Configuration List. See `routes` below.
     */
    @JvmName("kkarrlqdhwylbeyo")
    public suspend fun routes(`value`: Output<List<V3CustomDomainRouteConfigRouteArgs>>) {
        this.routes = value
    }

    @JvmName("kplxbsnqrfawxgql")
    public suspend fun routes(vararg values: Output<V3CustomDomainRouteConfigRouteArgs>) {
        this.routes = Output.all(values.asList())
    }

    /**
     * @param values Routing Configuration List. See `routes` below.
     */
    @JvmName("tklbonjabkvjetia")
    public suspend fun routes(values: List<Output<V3CustomDomainRouteConfigRouteArgs>>) {
        this.routes = Output.all(values)
    }

    /**
     * @param value Routing Configuration List. See `routes` below.
     */
    @JvmName("koxsgubjxkhrtvtc")
    public suspend fun routes(`value`: List<V3CustomDomainRouteConfigRouteArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    /**
     * @param argument Routing Configuration List. See `routes` below.
     */
    @JvmName("jqrhiwgjxpbfhxxi")
    public suspend fun routes(argument: List<suspend V3CustomDomainRouteConfigRouteArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Routing Configuration List. See `routes` below.
     */
    @JvmName("hgqtangnbnkvcjxo")
    public suspend fun routes(vararg argument: suspend V3CustomDomainRouteConfigRouteArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param argument Routing Configuration List. See `routes` below.
     */
    @JvmName("kdtmgruwkxhsvkny")
    public suspend fun routes(argument: suspend V3CustomDomainRouteConfigRouteArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V3CustomDomainRouteConfigRouteArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.routes = mapped
    }

    /**
     * @param values Routing Configuration List. See `routes` below.
     */
    @JvmName("fmhmglfqprgepnkp")
    public suspend fun routes(vararg values: V3CustomDomainRouteConfigRouteArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routes = mapped
    }

    internal fun build(): V3CustomDomainRouteConfigArgs = V3CustomDomainRouteConfigArgs(
        routes = routes,
    )
}
