@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property functionName Function name.
 * @property methods List of supported HTTP methods.
 * @property path Route matching rule.
 * @property qualifier Version or Alias.
 * @property rewriteConfig Override Configuration. See `rewrite_config` below.
 */
public data class V3CustomDomainRouteConfigRouteArgs(
    public val functionName: Output<String>? = null,
    public val methods: Output<List<String>>? = null,
    public val path: Output<String>? = null,
    public val qualifier: Output<String>? = null,
    public val rewriteConfig: Output<V3CustomDomainRouteConfigRouteRewriteConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteArgs.builder()
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .methods(methods?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .path(path?.applyValue({ args0 -> args0 }))
            .qualifier(qualifier?.applyValue({ args0 -> args0 }))
            .rewriteConfig(rewriteConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V3CustomDomainRouteConfigRouteArgs].
 */
@PulumiTagMarker
public class V3CustomDomainRouteConfigRouteArgsBuilder internal constructor() {
    private var functionName: Output<String>? = null

    private var methods: Output<List<String>>? = null

    private var path: Output<String>? = null

    private var qualifier: Output<String>? = null

    private var rewriteConfig: Output<V3CustomDomainRouteConfigRouteRewriteConfigArgs>? = null

    /**
     * @param value Function name.
     */
    @JvmName("shfflsrhqaamejpn")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value List of supported HTTP methods.
     */
    @JvmName("kkeuutoqvrbxvvwj")
    public suspend fun methods(`value`: Output<List<String>>) {
        this.methods = value
    }

    @JvmName("bumkrjinaiygfcka")
    public suspend fun methods(vararg values: Output<String>) {
        this.methods = Output.all(values.asList())
    }

    /**
     * @param values List of supported HTTP methods.
     */
    @JvmName("isdcvxpfaxohyink")
    public suspend fun methods(values: List<Output<String>>) {
        this.methods = Output.all(values)
    }

    /**
     * @param value Route matching rule.
     */
    @JvmName("bqxcsewnctxofbdu")
    public suspend fun path(`value`: Output<String>) {
        this.path = value
    }

    /**
     * @param value Version or Alias.
     */
    @JvmName("asudrptonyaihayh")
    public suspend fun qualifier(`value`: Output<String>) {
        this.qualifier = value
    }

    /**
     * @param value Override Configuration. See `rewrite_config` below.
     */
    @JvmName("qclractrxdbpfblb")
    public suspend fun rewriteConfig(`value`: Output<V3CustomDomainRouteConfigRouteRewriteConfigArgs>) {
        this.rewriteConfig = value
    }

    /**
     * @param value Function name.
     */
    @JvmName("dvrbjoayxxmenqcr")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value List of supported HTTP methods.
     */
    @JvmName("vuokblgbetgyxyqm")
    public suspend fun methods(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param values List of supported HTTP methods.
     */
    @JvmName("rjgljkxtjgnhvbbs")
    public suspend fun methods(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.methods = mapped
    }

    /**
     * @param value Route matching rule.
     */
    @JvmName("eeyacundoalwnatc")
    public suspend fun path(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.path = mapped
    }

    /**
     * @param value Version or Alias.
     */
    @JvmName("xueqlakmmnmoxoqd")
    public suspend fun qualifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.qualifier = mapped
    }

    /**
     * @param value Override Configuration. See `rewrite_config` below.
     */
    @JvmName("ptqmocbwjifhcmoc")
    public suspend fun rewriteConfig(`value`: V3CustomDomainRouteConfigRouteRewriteConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rewriteConfig = mapped
    }

    /**
     * @param argument Override Configuration. See `rewrite_config` below.
     */
    @JvmName("akiexryahqbvesbm")
    public suspend fun rewriteConfig(argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3CustomDomainRouteConfigRouteRewriteConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.rewriteConfig = mapped
    }

    internal fun build(): V3CustomDomainRouteConfigRouteArgs = V3CustomDomainRouteConfigRouteArgs(
        functionName = functionName,
        methods = methods,
        path = path,
        qualifier = qualifier,
        rewriteConfig = rewriteConfig,
    )
}
