@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property equalRules Exact Match Rule List. See `equal_rules` below.
 * @property regexRules Regular match rule list. See `regex_rules` below.
 * @property wildcardRules List of wildcard matching rules. See `wildcard_rules` below.
 */
public data class V3CustomDomainRouteConfigRouteRewriteConfigArgs(
    public val equalRules: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>>? =
        null,
    public val regexRules: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>>? =
        null,
    public val wildcardRules: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigArgs.builder()
            .equalRules(
                equalRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .regexRules(
                regexRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .wildcardRules(
                wildcardRules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V3CustomDomainRouteConfigRouteRewriteConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainRouteConfigRouteRewriteConfigArgsBuilder internal constructor() {
    private var equalRules: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>>? =
        null

    private var regexRules: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>>? =
        null

    private var wildcardRules:
        Output<List<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>>? = null

    /**
     * @param value Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("ptgleeefudvxixmt")
    public suspend fun equalRules(`value`: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>>) {
        this.equalRules = value
    }

    @JvmName("bixpoqqgxotsludb")
    public suspend fun equalRules(vararg values: Output<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>) {
        this.equalRules = Output.all(values.asList())
    }

    /**
     * @param values Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("ttnmxaodshiamcxj")
    public suspend fun equalRules(values: List<Output<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>>) {
        this.equalRules = Output.all(values)
    }

    /**
     * @param value Regular match rule list. See `regex_rules` below.
     */
    @JvmName("aymrxinxcvxkkacu")
    public suspend fun regexRules(`value`: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>>) {
        this.regexRules = value
    }

    @JvmName("ffgpehnbdjbyhhwf")
    public suspend fun regexRules(vararg values: Output<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>) {
        this.regexRules = Output.all(values.asList())
    }

    /**
     * @param values Regular match rule list. See `regex_rules` below.
     */
    @JvmName("fhepjqgwrudnijqb")
    public suspend fun regexRules(values: List<Output<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>>) {
        this.regexRules = Output.all(values)
    }

    /**
     * @param value List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("sstqvjnlooeeehij")
    public suspend fun wildcardRules(`value`: Output<List<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>>) {
        this.wildcardRules = value
    }

    @JvmName("juleejigkvqrmbll")
    public suspend fun wildcardRules(vararg values: Output<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>) {
        this.wildcardRules = Output.all(values.asList())
    }

    /**
     * @param values List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("rqatmppklxiopwki")
    public suspend fun wildcardRules(values: List<Output<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>>) {
        this.wildcardRules = Output.all(values)
    }

    /**
     * @param value Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("llnvqpodtcjyvimg")
    public suspend fun equalRules(`value`: List<V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.equalRules = mapped
    }

    /**
     * @param argument Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("yafvcblgiycbpyeq")
    public suspend fun equalRules(argument: List<suspend V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.equalRules = mapped
    }

    /**
     * @param argument Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("kvjajtlouevfvsxx")
    public suspend fun equalRules(vararg argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.equalRules = mapped
    }

    /**
     * @param argument Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("xcsfewbopxcekxjq")
    public suspend fun equalRules(argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.equalRules = mapped
    }

    /**
     * @param values Exact Match Rule List. See `equal_rules` below.
     */
    @JvmName("uruueeuyvbmtergd")
    public suspend fun equalRules(vararg values: V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.equalRules = mapped
    }

    /**
     * @param value Regular match rule list. See `regex_rules` below.
     */
    @JvmName("xlrejimcasyefndb")
    public suspend fun regexRules(`value`: List<V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regexRules = mapped
    }

    /**
     * @param argument Regular match rule list. See `regex_rules` below.
     */
    @JvmName("yjdhjtsqmncmchxs")
    public suspend fun regexRules(argument: List<suspend V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexRules = mapped
    }

    /**
     * @param argument Regular match rule list. See `regex_rules` below.
     */
    @JvmName("mosgwgcxtetvnkkp")
    public suspend fun regexRules(vararg argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.regexRules = mapped
    }

    /**
     * @param argument Regular match rule list. See `regex_rules` below.
     */
    @JvmName("uxconfnqxmgqumtl")
    public suspend fun regexRules(argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.regexRules = mapped
    }

    /**
     * @param values Regular match rule list. See `regex_rules` below.
     */
    @JvmName("eylfverpwwomaxeq")
    public suspend fun regexRules(vararg values: V3CustomDomainRouteConfigRouteRewriteConfigRegexRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regexRules = mapped
    }

    /**
     * @param value List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("josakwkburtkldhf")
    public suspend fun wildcardRules(`value`: List<V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardRules = mapped
    }

    /**
     * @param argument List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("edovntpmbfvackce")
    public suspend fun wildcardRules(argument: List<suspend V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.wildcardRules = mapped
    }

    /**
     * @param argument List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("pscunwqykjyjolnl")
    public suspend fun wildcardRules(vararg argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.wildcardRules = mapped
    }

    /**
     * @param argument List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("oftyohiusfxiatmw")
    public suspend fun wildcardRules(argument: suspend V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.wildcardRules = mapped
    }

    /**
     * @param values List of wildcard matching rules. See `wildcard_rules` below.
     */
    @JvmName("fmseuobolwdbewjk")
    public suspend fun wildcardRules(vararg values: V3CustomDomainRouteConfigRouteRewriteConfigWildcardRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.wildcardRules = mapped
    }

    internal fun build(): V3CustomDomainRouteConfigRouteRewriteConfigArgs =
        V3CustomDomainRouteConfigRouteRewriteConfigArgs(
            equalRules = equalRules,
            regexRules = regexRules,
            wildcardRules = wildcardRules,
        )
}
