@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property match Matching Rules.
 * @property replacement Replace Rules.
 */
public data class V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs(
    public val match: Output<String>? = null,
    public val replacement: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs.builder()
            .match(match?.applyValue({ args0 -> args0 }))
            .replacement(replacement?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs].
 */
@PulumiTagMarker
public class V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgsBuilder internal constructor() {
    private var match: Output<String>? = null

    private var replacement: Output<String>? = null

    /**
     * @param value Matching Rules.
     */
    @JvmName("bpldklgsamvjfpoe")
    public suspend fun match(`value`: Output<String>) {
        this.match = value
    }

    /**
     * @param value Replace Rules.
     */
    @JvmName("bfcnboukaqgipgxx")
    public suspend fun replacement(`value`: Output<String>) {
        this.replacement = value
    }

    /**
     * @param value Matching Rules.
     */
    @JvmName("vsdlcgtykscpjddx")
    public suspend fun match(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.match = mapped
    }

    /**
     * @param value Replace Rules.
     */
    @JvmName("nwgjolhqqudwkxxq")
    public suspend fun replacement(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replacement = mapped
    }

    internal fun build(): V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs =
        V3CustomDomainRouteConfigRouteRewriteConfigEqualRuleArgs(
            match = match,
            replacement = replacement,
        )
}
