@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainTlsConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property cipherSuites List of TLS cipher suites.
 * @property maxVersion The maximum version of TLS. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
 * @property minVersion TLS minimum version number. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
 */
public data class V3CustomDomainTlsConfigArgs(
    public val cipherSuites: Output<List<String>>? = null,
    public val maxVersion: Output<String>? = null,
    public val minVersion: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainTlsConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainTlsConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainTlsConfigArgs.builder()
            .cipherSuites(cipherSuites?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maxVersion(maxVersion?.applyValue({ args0 -> args0 }))
            .minVersion(minVersion?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3CustomDomainTlsConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainTlsConfigArgsBuilder internal constructor() {
    private var cipherSuites: Output<List<String>>? = null

    private var maxVersion: Output<String>? = null

    private var minVersion: Output<String>? = null

    /**
     * @param value List of TLS cipher suites.
     */
    @JvmName("ryxmtywbqaqktwmi")
    public suspend fun cipherSuites(`value`: Output<List<String>>) {
        this.cipherSuites = value
    }

    @JvmName("getvjrjnaxjxdaru")
    public suspend fun cipherSuites(vararg values: Output<String>) {
        this.cipherSuites = Output.all(values.asList())
    }

    /**
     * @param values List of TLS cipher suites.
     */
    @JvmName("nigdchurtshyeybc")
    public suspend fun cipherSuites(values: List<Output<String>>) {
        this.cipherSuites = Output.all(values)
    }

    /**
     * @param value The maximum version of TLS. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
     */
    @JvmName("qdawgkeetgeycnkx")
    public suspend fun maxVersion(`value`: Output<String>) {
        this.maxVersion = value
    }

    /**
     * @param value TLS minimum version number. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
     */
    @JvmName("vmaxpxngvoaelwgn")
    public suspend fun minVersion(`value`: Output<String>) {
        this.minVersion = value
    }

    /**
     * @param value List of TLS cipher suites.
     */
    @JvmName("pukruikgxbfuxriw")
    public suspend fun cipherSuites(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param values List of TLS cipher suites.
     */
    @JvmName("mvyjwuhegnmctsll")
    public suspend fun cipherSuites(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cipherSuites = mapped
    }

    /**
     * @param value The maximum version of TLS. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
     */
    @JvmName("aegyptvatlpbknkg")
    public suspend fun maxVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxVersion = mapped
    }

    /**
     * @param value TLS minimum version number. Enumeration values: TLSv1.3, TLSv1.2, TLSv1.1, TLSv1.0.
     */
    @JvmName("fmmgbqightdnjxlj")
    public suspend fun minVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minVersion = mapped
    }

    internal fun build(): V3CustomDomainTlsConfigArgs = V3CustomDomainTlsConfigArgs(
        cipherSuites = cipherSuites,
        maxVersion = maxVersion,
        minVersion = minVersion,
    )
}
