@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3CustomDomainWafConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableWaf Enable WAF protection.
 */
public data class V3CustomDomainWafConfigArgs(
    public val enableWaf: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3CustomDomainWafConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3CustomDomainWafConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3CustomDomainWafConfigArgs.builder()
            .enableWaf(enableWaf?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3CustomDomainWafConfigArgs].
 */
@PulumiTagMarker
public class V3CustomDomainWafConfigArgsBuilder internal constructor() {
    private var enableWaf: Output<Boolean>? = null

    /**
     * @param value Enable WAF protection.
     */
    @JvmName("wungajomhjckbiic")
    public suspend fun enableWaf(`value`: Output<Boolean>) {
        this.enableWaf = value
    }

    /**
     * @param value Enable WAF protection.
     */
    @JvmName("dauxoqaebawnwxjd")
    public suspend fun enableWaf(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableWaf = mapped
    }

    internal fun build(): V3CustomDomainWafConfigArgs = V3CustomDomainWafConfigArgs(
        enableWaf = enableWaf,
    )
}
