@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property checksum The CRC-64 value of the function code package.
 * @property ossBucketName The name of the OSS Bucket that stores the function code ZIP package.
 * @property ossObjectName The name of the OSS Object that stores the function code ZIP package.
 * @property zipFile The Base 64 encoding of the function code ZIP package.
 */
public data class V3FunctionCodeArgs(
    public val checksum: Output<String>? = null,
    public val ossBucketName: Output<String>? = null,
    public val ossObjectName: Output<String>? = null,
    public val zipFile: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCodeArgs.builder()
            .checksum(checksum?.applyValue({ args0 -> args0 }))
            .ossBucketName(ossBucketName?.applyValue({ args0 -> args0 }))
            .ossObjectName(ossObjectName?.applyValue({ args0 -> args0 }))
            .zipFile(zipFile?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionCodeArgs].
 */
@PulumiTagMarker
public class V3FunctionCodeArgsBuilder internal constructor() {
    private var checksum: Output<String>? = null

    private var ossBucketName: Output<String>? = null

    private var ossObjectName: Output<String>? = null

    private var zipFile: Output<String>? = null

    /**
     * @param value The CRC-64 value of the function code package.
     */
    @JvmName("qojuheanxjiyiegj")
    public suspend fun checksum(`value`: Output<String>) {
        this.checksum = value
    }

    /**
     * @param value The name of the OSS Bucket that stores the function code ZIP package.
     */
    @JvmName("ptooywbhahorsyfe")
    public suspend fun ossBucketName(`value`: Output<String>) {
        this.ossBucketName = value
    }

    /**
     * @param value The name of the OSS Object that stores the function code ZIP package.
     */
    @JvmName("jggagswkteqwtqrk")
    public suspend fun ossObjectName(`value`: Output<String>) {
        this.ossObjectName = value
    }

    /**
     * @param value The Base 64 encoding of the function code ZIP package.
     */
    @JvmName("ndpqjxevoxwijnun")
    public suspend fun zipFile(`value`: Output<String>) {
        this.zipFile = value
    }

    /**
     * @param value The CRC-64 value of the function code package.
     */
    @JvmName("inkgknkbvwigmmqj")
    public suspend fun checksum(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checksum = mapped
    }

    /**
     * @param value The name of the OSS Bucket that stores the function code ZIP package.
     */
    @JvmName("mmgcbpsckrdfujmq")
    public suspend fun ossBucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossBucketName = mapped
    }

    /**
     * @param value The name of the OSS Object that stores the function code ZIP package.
     */
    @JvmName("jiudinvcglsjjssg")
    public suspend fun ossObjectName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ossObjectName = mapped
    }

    /**
     * @param value The Base 64 encoding of the function code ZIP package.
     */
    @JvmName("pvckhuuwsnveriov")
    public suspend fun zipFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zipFile = mapped
    }

    internal fun build(): V3FunctionCodeArgs = V3FunctionCodeArgs(
        checksum = checksum,
        ossBucketName = ossBucketName,
        ossObjectName = ossObjectName,
        zipFile = zipFile,
    )
}
