@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accelerationInfo (Deprecated since v1.228.0) - Image Acceleration Information (Obsolete).
 * @property accelerationType Whether to enable Image acceleration. Default: The Default value, indicating that image acceleration is enabled. None: indicates that image acceleration is disabled. (Obsolete).
 * @property acrInstanceId ACR Enterprise version Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete).
 * @property commands Container startup parameters.
 * @property entrypoints Container start command.
 * @property healthCheckConfig Function custom health check configuration. See `health_check_config` below.
 * @property image The container Image address.
 * @property port The listening port of the HTTP Server when the custom container runs.
 * @property resolvedImageUri The actual digest version of the deployed Image. The code version specified by this digest is used when the function starts.
 */
public data class V3FunctionCustomContainerConfigArgs(
    @Deprecated(
        message = """
  Field 'acceleration_info' has been deprecated from provider version 1.228.0. Image Acceleration
      Information (Obsolete)
  """,
    )
    public val accelerationInfo: Output<V3FunctionCustomContainerConfigAccelerationInfoArgs>? = null,
    @Deprecated(
        message = """
  Field 'acceleration_type' has been deprecated from provider version 1.228.0. Whether to enable
      Image acceleration. Default: The Default value, indicating that image acceleration is enabled.
      None: indicates that image acceleration is disabled. (Obsolete)
  """,
    )
    public val accelerationType: Output<String>? = null,
    @Deprecated(
        message = """
  Field 'acr_instance_id' has been deprecated from provider version 1.228.0. ACR Enterprise version
      Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete)
  """,
    )
    public val acrInstanceId: Output<String>? = null,
    public val commands: Output<List<String>>? = null,
    public val entrypoints: Output<List<String>>? = null,
    public val healthCheckConfig: Output<V3FunctionCustomContainerConfigHealthCheckConfigArgs>? =
        null,
    public val image: Output<String>? = null,
    public val port: Output<Int>? = null,
    public val resolvedImageUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigArgs.builder()
            .accelerationInfo(accelerationInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .accelerationType(accelerationType?.applyValue({ args0 -> args0 }))
            .acrInstanceId(acrInstanceId?.applyValue({ args0 -> args0 }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .entrypoints(entrypoints?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .image(image?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .resolvedImageUri(resolvedImageUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionCustomContainerConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionCustomContainerConfigArgsBuilder internal constructor() {
    private var accelerationInfo: Output<V3FunctionCustomContainerConfigAccelerationInfoArgs>? = null

    private var accelerationType: Output<String>? = null

    private var acrInstanceId: Output<String>? = null

    private var commands: Output<List<String>>? = null

    private var entrypoints: Output<List<String>>? = null

    private var healthCheckConfig: Output<V3FunctionCustomContainerConfigHealthCheckConfigArgs>? =
        null

    private var image: Output<String>? = null

    private var port: Output<Int>? = null

    private var resolvedImageUri: Output<String>? = null

    /**
     * @param value (Deprecated since v1.228.0) - Image Acceleration Information (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acceleration_info' has been deprecated from provider version 1.228.0. Image Acceleration
      Information (Obsolete)
  """,
    )
    @JvmName("sokdohouubovbepk")
    public suspend fun accelerationInfo(`value`: Output<V3FunctionCustomContainerConfigAccelerationInfoArgs>) {
        this.accelerationInfo = value
    }

    /**
     * @param value Whether to enable Image acceleration. Default: The Default value, indicating that image acceleration is enabled. None: indicates that image acceleration is disabled. (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acceleration_type' has been deprecated from provider version 1.228.0. Whether to enable
      Image acceleration. Default: The Default value, indicating that image acceleration is enabled.
      None: indicates that image acceleration is disabled. (Obsolete)
  """,
    )
    @JvmName("obkjpdpwgswjfudu")
    public suspend fun accelerationType(`value`: Output<String>) {
        this.accelerationType = value
    }

    /**
     * @param value ACR Enterprise version Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acr_instance_id' has been deprecated from provider version 1.228.0. ACR Enterprise version
      Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete)
  """,
    )
    @JvmName("gpjyingjfhctbhob")
    public suspend fun acrInstanceId(`value`: Output<String>) {
        this.acrInstanceId = value
    }

    /**
     * @param value Container startup parameters.
     */
    @JvmName("bbqjjefenjrdinuy")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("rkmlqysuyftjvpka")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Container startup parameters.
     */
    @JvmName("eajkeiamccieuetq")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Container start command.
     */
    @JvmName("yqontfcatraqbgve")
    public suspend fun entrypoints(`value`: Output<List<String>>) {
        this.entrypoints = value
    }

    @JvmName("rxsltmsuevxajgoy")
    public suspend fun entrypoints(vararg values: Output<String>) {
        this.entrypoints = Output.all(values.asList())
    }

    /**
     * @param values Container start command.
     */
    @JvmName("lveqiqlobqbjyaxt")
    public suspend fun entrypoints(values: List<Output<String>>) {
        this.entrypoints = Output.all(values)
    }

    /**
     * @param value Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("mwrhpgmdogsfmipw")
    public suspend fun healthCheckConfig(`value`: Output<V3FunctionCustomContainerConfigHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value The container Image address.
     */
    @JvmName("cygdakwleigyqghh")
    public suspend fun image(`value`: Output<String>) {
        this.image = value
    }

    /**
     * @param value The listening port of the HTTP Server when the custom container runs.
     */
    @JvmName("qpgkvyhbpjtxtabn")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value The actual digest version of the deployed Image. The code version specified by this digest is used when the function starts.
     */
    @JvmName("mhgslceutghsufmq")
    public suspend fun resolvedImageUri(`value`: Output<String>) {
        this.resolvedImageUri = value
    }

    /**
     * @param value (Deprecated since v1.228.0) - Image Acceleration Information (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acceleration_info' has been deprecated from provider version 1.228.0. Image Acceleration
      Information (Obsolete)
  """,
    )
    @JvmName("vipmgtumkefewnop")
    public suspend fun accelerationInfo(`value`: V3FunctionCustomContainerConfigAccelerationInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerationInfo = mapped
    }

    /**
     * @param argument (Deprecated since v1.228.0) - Image Acceleration Information (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acceleration_info' has been deprecated from provider version 1.228.0. Image Acceleration
      Information (Obsolete)
  """,
    )
    @JvmName("uaqdqugsyvidcmqs")
    public suspend fun accelerationInfo(argument: suspend V3FunctionCustomContainerConfigAccelerationInfoArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomContainerConfigAccelerationInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accelerationInfo = mapped
    }

    /**
     * @param value Whether to enable Image acceleration. Default: The Default value, indicating that image acceleration is enabled. None: indicates that image acceleration is disabled. (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acceleration_type' has been deprecated from provider version 1.228.0. Whether to enable
      Image acceleration. Default: The Default value, indicating that image acceleration is enabled.
      None: indicates that image acceleration is disabled. (Obsolete)
  """,
    )
    @JvmName("gnlfpbdpqyqflkov")
    public suspend fun accelerationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accelerationType = mapped
    }

    /**
     * @param value ACR Enterprise version Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete).
     */
    @Deprecated(
        message = """
  Field 'acr_instance_id' has been deprecated from provider version 1.228.0. ACR Enterprise version
      Image Repository ID, which must be entered when using ACR Enterprise version image. (Obsolete)
  """,
    )
    @JvmName("qrfctuchxpetttfl")
    public suspend fun acrInstanceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.acrInstanceId = mapped
    }

    /**
     * @param value Container startup parameters.
     */
    @JvmName("ktfrykltuokerwxr")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Container startup parameters.
     */
    @JvmName("mggivleeldbqslbs")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Container start command.
     */
    @JvmName("jrqyvlbmfxlpobaa")
    public suspend fun entrypoints(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.entrypoints = mapped
    }

    /**
     * @param values Container start command.
     */
    @JvmName("xbwfrdjeagkdwkdr")
    public suspend fun entrypoints(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.entrypoints = mapped
    }

    /**
     * @param value Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("kbuivxpcufbfagui")
    public suspend fun healthCheckConfig(`value`: V3FunctionCustomContainerConfigHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("tclwlydrlskvwkte")
    public suspend fun healthCheckConfig(argument: suspend V3FunctionCustomContainerConfigHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomContainerConfigHealthCheckConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value The container Image address.
     */
    @JvmName("xlbrkxfffhlfhrfb")
    public suspend fun image(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.image = mapped
    }

    /**
     * @param value The listening port of the HTTP Server when the custom container runs.
     */
    @JvmName("gssqbkrpkahtipqd")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The actual digest version of the deployed Image. The code version specified by this digest is used when the function starts.
     */
    @JvmName("xfrgqrwqjyvifbfl")
    public suspend fun resolvedImageUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resolvedImageUri = mapped
    }

    internal fun build(): V3FunctionCustomContainerConfigArgs = V3FunctionCustomContainerConfigArgs(
        accelerationInfo = accelerationInfo,
        accelerationType = accelerationType,
        acrInstanceId = acrInstanceId,
        commands = commands,
        entrypoints = entrypoints,
        healthCheckConfig = healthCheckConfig,
        image = image,
        port = port,
        resolvedImageUri = resolvedImageUri,
    )
}
