@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigHealthCheckConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property failureThreshold
 * @property httpGetUrl
 * @property initialDelaySeconds
 * @property periodSeconds
 * @property successThreshold
 * @property timeoutSeconds
 */
public data class V3FunctionCustomContainerConfigHealthCheckConfigArgs(
    public val failureThreshold: Output<Int>? = null,
    public val httpGetUrl: Output<String>? = null,
    public val initialDelaySeconds: Output<Int>? = null,
    public val periodSeconds: Output<Int>? = null,
    public val successThreshold: Output<Int>? = null,
    public val timeoutSeconds: Output<Int>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigHealthCheckConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigHealthCheckConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCustomContainerConfigHealthCheckConfigArgs.builder()
            .failureThreshold(failureThreshold?.applyValue({ args0 -> args0 }))
            .httpGetUrl(httpGetUrl?.applyValue({ args0 -> args0 }))
            .initialDelaySeconds(initialDelaySeconds?.applyValue({ args0 -> args0 }))
            .periodSeconds(periodSeconds?.applyValue({ args0 -> args0 }))
            .successThreshold(successThreshold?.applyValue({ args0 -> args0 }))
            .timeoutSeconds(timeoutSeconds?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionCustomContainerConfigHealthCheckConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionCustomContainerConfigHealthCheckConfigArgsBuilder internal constructor() {
    private var failureThreshold: Output<Int>? = null

    private var httpGetUrl: Output<String>? = null

    private var initialDelaySeconds: Output<Int>? = null

    private var periodSeconds: Output<Int>? = null

    private var successThreshold: Output<Int>? = null

    private var timeoutSeconds: Output<Int>? = null

    /**
     * @param value
     */
    @JvmName("yqgohfuejjwsreqc")
    public suspend fun failureThreshold(`value`: Output<Int>) {
        this.failureThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("hcbtraefxwgalyyv")
    public suspend fun httpGetUrl(`value`: Output<String>) {
        this.httpGetUrl = value
    }

    /**
     * @param value
     */
    @JvmName("wwonhchwuvrpcgdj")
    public suspend fun initialDelaySeconds(`value`: Output<Int>) {
        this.initialDelaySeconds = value
    }

    /**
     * @param value
     */
    @JvmName("dhxtovnmcinrogux")
    public suspend fun periodSeconds(`value`: Output<Int>) {
        this.periodSeconds = value
    }

    /**
     * @param value
     */
    @JvmName("degvphdbgimeukje")
    public suspend fun successThreshold(`value`: Output<Int>) {
        this.successThreshold = value
    }

    /**
     * @param value
     */
    @JvmName("tlteenlkvkyileus")
    public suspend fun timeoutSeconds(`value`: Output<Int>) {
        this.timeoutSeconds = value
    }

    /**
     * @param value
     */
    @JvmName("aajikgjlhemnmpwn")
    public suspend fun failureThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.failureThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("drbevdbuimyfswvc")
    public suspend fun httpGetUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpGetUrl = mapped
    }

    /**
     * @param value
     */
    @JvmName("bmfmjtfljoscohdn")
    public suspend fun initialDelaySeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialDelaySeconds = mapped
    }

    /**
     * @param value
     */
    @JvmName("otaaycyrogpjvtxj")
    public suspend fun periodSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.periodSeconds = mapped
    }

    /**
     * @param value
     */
    @JvmName("ajgvqwvggbkshbtu")
    public suspend fun successThreshold(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.successThreshold = mapped
    }

    /**
     * @param value
     */
    @JvmName("wncsistfixuaiupt")
    public suspend fun timeoutSeconds(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeoutSeconds = mapped
    }

    internal fun build(): V3FunctionCustomContainerConfigHealthCheckConfigArgs =
        V3FunctionCustomContainerConfigHealthCheckConfigArgs(
            failureThreshold = failureThreshold,
            httpGetUrl = httpGetUrl,
            initialDelaySeconds = initialDelaySeconds,
            periodSeconds = periodSeconds,
            successThreshold = successThreshold,
            timeoutSeconds = timeoutSeconds,
        )
}
