@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property dnsOptions List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
 * @property nameServers IP Address List of DNS servers.
 * @property searches DNS search domain list.
 */
public data class V3FunctionCustomDnsArgs(
    public val dnsOptions: Output<List<V3FunctionCustomDnsDnsOptionArgs>>? = null,
    public val nameServers: Output<List<String>>? = null,
    public val searches: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsArgs.builder()
            .dnsOptions(
                dnsOptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .nameServers(nameServers?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .searches(searches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [V3FunctionCustomDnsArgs].
 */
@PulumiTagMarker
public class V3FunctionCustomDnsArgsBuilder internal constructor() {
    private var dnsOptions: Output<List<V3FunctionCustomDnsDnsOptionArgs>>? = null

    private var nameServers: Output<List<String>>? = null

    private var searches: Output<List<String>>? = null

    /**
     * @param value List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("ahvjkydqoqheqpds")
    public suspend fun dnsOptions(`value`: Output<List<V3FunctionCustomDnsDnsOptionArgs>>) {
        this.dnsOptions = value
    }

    @JvmName("lsppmfywqigbohra")
    public suspend fun dnsOptions(vararg values: Output<V3FunctionCustomDnsDnsOptionArgs>) {
        this.dnsOptions = Output.all(values.asList())
    }

    /**
     * @param values List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("etbkcurmotpqjmis")
    public suspend fun dnsOptions(values: List<Output<V3FunctionCustomDnsDnsOptionArgs>>) {
        this.dnsOptions = Output.all(values)
    }

    /**
     * @param value IP Address List of DNS servers.
     */
    @JvmName("yqiwhtcqqrmbqrwv")
    public suspend fun nameServers(`value`: Output<List<String>>) {
        this.nameServers = value
    }

    @JvmName("beaprnkangbtwlxg")
    public suspend fun nameServers(vararg values: Output<String>) {
        this.nameServers = Output.all(values.asList())
    }

    /**
     * @param values IP Address List of DNS servers.
     */
    @JvmName("gmmjoaybggpcgyhq")
    public suspend fun nameServers(values: List<Output<String>>) {
        this.nameServers = Output.all(values)
    }

    /**
     * @param value DNS search domain list.
     */
    @JvmName("cyllwyfiothjxlow")
    public suspend fun searches(`value`: Output<List<String>>) {
        this.searches = value
    }

    @JvmName("iaerhfephnucmiqd")
    public suspend fun searches(vararg values: Output<String>) {
        this.searches = Output.all(values.asList())
    }

    /**
     * @param values DNS search domain list.
     */
    @JvmName("yodtqnanalqrsunu")
    public suspend fun searches(values: List<Output<String>>) {
        this.searches = Output.all(values)
    }

    /**
     * @param value List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("tldbixpjbtppxmpo")
    public suspend fun dnsOptions(`value`: List<V3FunctionCustomDnsDnsOptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dnsOptions = mapped
    }

    /**
     * @param argument List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("itkjsslcavnohkbr")
    public suspend fun dnsOptions(argument: List<suspend V3FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param argument List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("vqwiftcefhfjgjun")
    public suspend fun dnsOptions(vararg argument: suspend V3FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param argument List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("popxkeqkfmloljoy")
    public suspend fun dnsOptions(argument: suspend V3FunctionCustomDnsDnsOptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V3FunctionCustomDnsDnsOptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.dnsOptions = mapped
    }

    /**
     * @param values List of configuration items in the resolv.conf file. Each item corresponds to a key-value pair in the format of key:value, where the key is required. See `dns_options` below.
     */
    @JvmName("oteaepbjkkujolps")
    public suspend fun dnsOptions(vararg values: V3FunctionCustomDnsDnsOptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dnsOptions = mapped
    }

    /**
     * @param value IP Address List of DNS servers.
     */
    @JvmName("qvdlsdidygchvtlp")
    public suspend fun nameServers(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param values IP Address List of DNS servers.
     */
    @JvmName("kxvdvnviinasfqhu")
    public suspend fun nameServers(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.nameServers = mapped
    }

    /**
     * @param value DNS search domain list.
     */
    @JvmName("qaaurpdghcxtgmwd")
    public suspend fun searches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    /**
     * @param values DNS search domain list.
     */
    @JvmName("hskmqdumumrkxjsq")
    public suspend fun searches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.searches = mapped
    }

    internal fun build(): V3FunctionCustomDnsArgs = V3FunctionCustomDnsArgs(
        dnsOptions = dnsOptions,
        nameServers = nameServers,
        searches = searches,
    )
}
