@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsDnsOptionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Configuration Item Name.
 * @property value Configuration Item Value.
 */
public data class V3FunctionCustomDnsDnsOptionArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsDnsOptionArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsDnsOptionArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCustomDnsDnsOptionArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionCustomDnsDnsOptionArgs].
 */
@PulumiTagMarker
public class V3FunctionCustomDnsDnsOptionArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Configuration Item Name.
     */
    @JvmName("xfvepuvkcikrqcjj")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Configuration Item Value.
     */
    @JvmName("sssbvmjecwmvhofh")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Configuration Item Name.
     */
    @JvmName("hclkqrcplnxlpnyg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Configuration Item Value.
     */
    @JvmName("wqcuohmunkoxaehk")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): V3FunctionCustomDnsDnsOptionArgs = V3FunctionCustomDnsDnsOptionArgs(
        name = name,
        `value` = `value`,
    )
}
