@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property args Instance startup parameters.
 * @property commands Instance start command.
 * @property healthCheckConfig Function custom health check configuration. See `health_check_config` below.
 * @property port The listening port of the HTTP Server.
 */
public data class V3FunctionCustomRuntimeConfigArgs(
    public val args: Output<List<String>>? = null,
    public val commands: Output<List<String>>? = null,
    public val healthCheckConfig: Output<V3FunctionCustomRuntimeConfigHealthCheckConfigArgs>? = null,
    public val port: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionCustomRuntimeConfigArgs.builder()
            .args(args?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .commands(commands?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .healthCheckConfig(healthCheckConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .port(port?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionCustomRuntimeConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionCustomRuntimeConfigArgsBuilder internal constructor() {
    private var args: Output<List<String>>? = null

    private var commands: Output<List<String>>? = null

    private var healthCheckConfig: Output<V3FunctionCustomRuntimeConfigHealthCheckConfigArgs>? = null

    private var port: Output<Int>? = null

    /**
     * @param value Instance startup parameters.
     */
    @JvmName("woopjifvrdavowsk")
    public suspend fun args(`value`: Output<List<String>>) {
        this.args = value
    }

    @JvmName("schpqjlkjdnyxxxa")
    public suspend fun args(vararg values: Output<String>) {
        this.args = Output.all(values.asList())
    }

    /**
     * @param values Instance startup parameters.
     */
    @JvmName("vnifyvhhulsqnoyr")
    public suspend fun args(values: List<Output<String>>) {
        this.args = Output.all(values)
    }

    /**
     * @param value Instance start command.
     */
    @JvmName("wefurxidirwgkotn")
    public suspend fun commands(`value`: Output<List<String>>) {
        this.commands = value
    }

    @JvmName("awwehbgeasxaloag")
    public suspend fun commands(vararg values: Output<String>) {
        this.commands = Output.all(values.asList())
    }

    /**
     * @param values Instance start command.
     */
    @JvmName("kfygmdudxpfnxmhr")
    public suspend fun commands(values: List<Output<String>>) {
        this.commands = Output.all(values)
    }

    /**
     * @param value Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("jjmuntalokwchvcj")
    public suspend fun healthCheckConfig(`value`: Output<V3FunctionCustomRuntimeConfigHealthCheckConfigArgs>) {
        this.healthCheckConfig = value
    }

    /**
     * @param value The listening port of the HTTP Server.
     */
    @JvmName("avsdgfrreeprbhbi")
    public suspend fun port(`value`: Output<Int>) {
        this.port = value
    }

    /**
     * @param value Instance startup parameters.
     */
    @JvmName("jgnhdnpvrcynennf")
    public suspend fun args(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param values Instance startup parameters.
     */
    @JvmName("hcrdkmpyxmyehogn")
    public suspend fun args(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.args = mapped
    }

    /**
     * @param value Instance start command.
     */
    @JvmName("loywmeipvjykejpp")
    public suspend fun commands(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param values Instance start command.
     */
    @JvmName("diwttjgiojhibjfn")
    public suspend fun commands(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commands = mapped
    }

    /**
     * @param value Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("qehfytobfqkbrtws")
    public suspend fun healthCheckConfig(`value`: V3FunctionCustomRuntimeConfigHealthCheckConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfig = mapped
    }

    /**
     * @param argument Function custom health check configuration. See `health_check_config` below.
     */
    @JvmName("ycdaaowhehjnujdi")
    public suspend fun healthCheckConfig(argument: suspend V3FunctionCustomRuntimeConfigHealthCheckConfigArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionCustomRuntimeConfigHealthCheckConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfig = mapped
    }

    /**
     * @param value The listening port of the HTTP Server.
     */
    @JvmName("lfjlpfpuvigsncdi")
    public suspend fun port(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    internal fun build(): V3FunctionCustomRuntimeConfigArgs = V3FunctionCustomRuntimeConfigArgs(
        args = args,
        commands = commands,
        healthCheckConfig = healthCheckConfig,
        port = port,
    )
}
