@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionGpuConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property gpuMemorySize GPU memory specification, unit: MB, multiple of 1024MB.
 * @property gpuType GPU card architecture.
 * - fc.gpu.tesla.1 indicates the type of the Tesla Architecture Series card of the GPU instance (the same as the NVIDIA T4 card type).
 * - fc.gpu.ampere.1 indicates the GPU instance type of Ampere Architecture Series card (same as NVIDIA A10 card type).
 * - fc.gpu.ada.1 Indicates the GPU instance Ada Lovelace architecture family card type.
 */
public data class V3FunctionGpuConfigArgs(
    public val gpuMemorySize: Output<Int>? = null,
    public val gpuType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionGpuConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionGpuConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionGpuConfigArgs.builder()
            .gpuMemorySize(gpuMemorySize?.applyValue({ args0 -> args0 }))
            .gpuType(gpuType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionGpuConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionGpuConfigArgsBuilder internal constructor() {
    private var gpuMemorySize: Output<Int>? = null

    private var gpuType: Output<String>? = null

    /**
     * @param value GPU memory specification, unit: MB, multiple of 1024MB.
     */
    @JvmName("dxqtdqhaqngfbiuv")
    public suspend fun gpuMemorySize(`value`: Output<Int>) {
        this.gpuMemorySize = value
    }

    /**
     * @param value GPU card architecture.
     * - fc.gpu.tesla.1 indicates the type of the Tesla Architecture Series card of the GPU instance (the same as the NVIDIA T4 card type).
     * - fc.gpu.ampere.1 indicates the GPU instance type of Ampere Architecture Series card (same as NVIDIA A10 card type).
     * - fc.gpu.ada.1 Indicates the GPU instance Ada Lovelace architecture family card type.
     */
    @JvmName("rpljcnucfmdioqnd")
    public suspend fun gpuType(`value`: Output<String>) {
        this.gpuType = value
    }

    /**
     * @param value GPU memory specification, unit: MB, multiple of 1024MB.
     */
    @JvmName("utoluuxlvbqhjqnh")
    public suspend fun gpuMemorySize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuMemorySize = mapped
    }

    /**
     * @param value GPU card architecture.
     * - fc.gpu.tesla.1 indicates the type of the Tesla Architecture Series card of the GPU instance (the same as the NVIDIA T4 card type).
     * - fc.gpu.ampere.1 indicates the GPU instance type of Ampere Architecture Series card (same as NVIDIA A10 card type).
     * - fc.gpu.ada.1 Indicates the GPU instance Ada Lovelace architecture family card type.
     */
    @JvmName("bfarjpkridjjvmfp")
    public suspend fun gpuType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gpuType = mapped
    }

    internal fun build(): V3FunctionGpuConfigArgs = V3FunctionGpuConfigArgs(
        gpuMemorySize = gpuMemorySize,
        gpuType = gpuType,
    )
}
