@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property initializer Initializer handler method configuration. See `initializer` below.
 * @property preStop PreStop handler method configuration. See `pre_stop` below.
 */
public data class V3FunctionInstanceLifecycleConfigArgs(
    public val initializer: Output<V3FunctionInstanceLifecycleConfigInitializerArgs>? = null,
    public val preStop: Output<V3FunctionInstanceLifecycleConfigPreStopArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigArgs.builder()
            .initializer(initializer?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .preStop(preStop?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [V3FunctionInstanceLifecycleConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionInstanceLifecycleConfigArgsBuilder internal constructor() {
    private var initializer: Output<V3FunctionInstanceLifecycleConfigInitializerArgs>? = null

    private var preStop: Output<V3FunctionInstanceLifecycleConfigPreStopArgs>? = null

    /**
     * @param value Initializer handler method configuration. See `initializer` below.
     */
    @JvmName("hddaqxkntvlaqboc")
    public suspend fun initializer(`value`: Output<V3FunctionInstanceLifecycleConfigInitializerArgs>) {
        this.initializer = value
    }

    /**
     * @param value PreStop handler method configuration. See `pre_stop` below.
     */
    @JvmName("jmambwlhlnuhjdej")
    public suspend fun preStop(`value`: Output<V3FunctionInstanceLifecycleConfigPreStopArgs>) {
        this.preStop = value
    }

    /**
     * @param value Initializer handler method configuration. See `initializer` below.
     */
    @JvmName("vylpuiemfkwjfptt")
    public suspend fun initializer(`value`: V3FunctionInstanceLifecycleConfigInitializerArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initializer = mapped
    }

    /**
     * @param argument Initializer handler method configuration. See `initializer` below.
     */
    @JvmName("upquewqwaxcegucq")
    public suspend fun initializer(argument: suspend V3FunctionInstanceLifecycleConfigInitializerArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionInstanceLifecycleConfigInitializerArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.initializer = mapped
    }

    /**
     * @param value PreStop handler method configuration. See `pre_stop` below.
     */
    @JvmName("ujuhxokxsdarpudf")
    public suspend fun preStop(`value`: V3FunctionInstanceLifecycleConfigPreStopArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preStop = mapped
    }

    /**
     * @param argument PreStop handler method configuration. See `pre_stop` below.
     */
    @JvmName("kpllwvqcepcghoue")
    public suspend fun preStop(argument: suspend V3FunctionInstanceLifecycleConfigPreStopArgsBuilder.() -> Unit) {
        val toBeMapped = V3FunctionInstanceLifecycleConfigPreStopArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.preStop = mapped
    }

    internal fun build(): V3FunctionInstanceLifecycleConfigArgs =
        V3FunctionInstanceLifecycleConfigArgs(
            initializer = initializer,
            preStop = preStop,
        )
}
