@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property handler Function Handler: the call entry for the function compute system to run your function.
 * @property timeout The maximum running time of the function, in seconds.
 */
public data class V3FunctionInstanceLifecycleConfigPreStopArgs(
    public val handler: Output<String>? = null,
    public val timeout: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs = com.pulumi.alicloud.fc.inputs.V3FunctionInstanceLifecycleConfigPreStopArgs.builder()
        .handler(handler?.applyValue({ args0 -> args0 }))
        .timeout(timeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionInstanceLifecycleConfigPreStopArgs].
 */
@PulumiTagMarker
public class V3FunctionInstanceLifecycleConfigPreStopArgsBuilder internal constructor() {
    private var handler: Output<String>? = null

    private var timeout: Output<Int>? = null

    /**
     * @param value Function Handler: the call entry for the function compute system to run your function.
     */
    @JvmName("ynxkmeojdokekuus")
    public suspend fun handler(`value`: Output<String>) {
        this.handler = value
    }

    /**
     * @param value The maximum running time of the function, in seconds.
     */
    @JvmName("mjpgxcuxuwdmijeu")
    public suspend fun timeout(`value`: Output<Int>) {
        this.timeout = value
    }

    /**
     * @param value Function Handler: the call entry for the function compute system to run your function.
     */
    @JvmName("qyhanmxtrmxitlun")
    public suspend fun handler(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.handler = mapped
    }

    /**
     * @param value The maximum running time of the function, in seconds.
     */
    @JvmName("vugjdweupghwkcht")
    public suspend fun timeout(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeout = mapped
    }

    internal fun build(): V3FunctionInstanceLifecycleConfigPreStopArgs =
        V3FunctionInstanceLifecycleConfigPreStopArgs(
            handler = handler,
            timeout = timeout,
        )
}
