@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableInstanceMetrics After this feature is enabled, you can view core metrics such as instance-level CPU usage, memory usage, instance network status, and the number of requests within an instance. false: The default value, which means that instance-level metrics are turned off. true: indicates that instance-level metrics are enabled.
 * @property enableRequestMetrics After this function is enabled, you can view the time and memory consumed by a call to all functions under this service. false: indicates that request-level metrics are turned off. true: The default value, indicating that request-level metrics are enabled.
 * @property logBeginRule Log Line First Matching Rules.
 * @property logstore The Logstore name of log service.
 * @property project The name of the log service Project.
 */
public data class V3FunctionLogConfigArgs(
    public val enableInstanceMetrics: Output<Boolean>? = null,
    public val enableRequestMetrics: Output<Boolean>? = null,
    public val logBeginRule: Output<String>? = null,
    public val logstore: Output<String>? = null,
    public val project: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionLogConfigArgs.builder()
            .enableInstanceMetrics(enableInstanceMetrics?.applyValue({ args0 -> args0 }))
            .enableRequestMetrics(enableRequestMetrics?.applyValue({ args0 -> args0 }))
            .logBeginRule(logBeginRule?.applyValue({ args0 -> args0 }))
            .logstore(logstore?.applyValue({ args0 -> args0 }))
            .project(project?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionLogConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionLogConfigArgsBuilder internal constructor() {
    private var enableInstanceMetrics: Output<Boolean>? = null

    private var enableRequestMetrics: Output<Boolean>? = null

    private var logBeginRule: Output<String>? = null

    private var logstore: Output<String>? = null

    private var project: Output<String>? = null

    /**
     * @param value After this feature is enabled, you can view core metrics such as instance-level CPU usage, memory usage, instance network status, and the number of requests within an instance. false: The default value, which means that instance-level metrics are turned off. true: indicates that instance-level metrics are enabled.
     */
    @JvmName("wrtuwxwxptakaika")
    public suspend fun enableInstanceMetrics(`value`: Output<Boolean>) {
        this.enableInstanceMetrics = value
    }

    /**
     * @param value After this function is enabled, you can view the time and memory consumed by a call to all functions under this service. false: indicates that request-level metrics are turned off. true: The default value, indicating that request-level metrics are enabled.
     */
    @JvmName("kxsldbcrkcuastwu")
    public suspend fun enableRequestMetrics(`value`: Output<Boolean>) {
        this.enableRequestMetrics = value
    }

    /**
     * @param value Log Line First Matching Rules.
     */
    @JvmName("bchtqisnygptthqv")
    public suspend fun logBeginRule(`value`: Output<String>) {
        this.logBeginRule = value
    }

    /**
     * @param value The Logstore name of log service.
     */
    @JvmName("cauibrachhunkndm")
    public suspend fun logstore(`value`: Output<String>) {
        this.logstore = value
    }

    /**
     * @param value The name of the log service Project.
     */
    @JvmName("qyaxvskhdqbdppjf")
    public suspend fun project(`value`: Output<String>) {
        this.project = value
    }

    /**
     * @param value After this feature is enabled, you can view core metrics such as instance-level CPU usage, memory usage, instance network status, and the number of requests within an instance. false: The default value, which means that instance-level metrics are turned off. true: indicates that instance-level metrics are enabled.
     */
    @JvmName("npgtmckwxjnvrxgl")
    public suspend fun enableInstanceMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInstanceMetrics = mapped
    }

    /**
     * @param value After this function is enabled, you can view the time and memory consumed by a call to all functions under this service. false: indicates that request-level metrics are turned off. true: The default value, indicating that request-level metrics are enabled.
     */
    @JvmName("cnkwkydilioiyvek")
    public suspend fun enableRequestMetrics(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableRequestMetrics = mapped
    }

    /**
     * @param value Log Line First Matching Rules.
     */
    @JvmName("vjkwoaakcjqyfsog")
    public suspend fun logBeginRule(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logBeginRule = mapped
    }

    /**
     * @param value The Logstore name of log service.
     */
    @JvmName("htlyipcgnqgfhtap")
    public suspend fun logstore(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logstore = mapped
    }

    /**
     * @param value The name of the log service Project.
     */
    @JvmName("bslkrmqjfxfrsalm")
    public suspend fun project(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.project = mapped
    }

    internal fun build(): V3FunctionLogConfigArgs = V3FunctionLogConfigArgs(
        enableInstanceMetrics = enableInstanceMetrics,
        enableRequestMetrics = enableRequestMetrics,
        logBeginRule = logBeginRule,
        logstore = logstore,
        project = project,
    )
}
