@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property groupId Group ID.
 * @property mountPoints Mount point list. See `mount_points` below.
 * @property userId Account ID.
 */
public data class V3FunctionNasConfigArgs(
    public val groupId: Output<Int>? = null,
    public val mountPoints: Output<List<V3FunctionNasConfigMountPointArgs>>? = null,
    public val userId: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigArgs.builder()
            .groupId(groupId?.applyValue({ args0 -> args0 }))
            .mountPoints(
                mountPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userId(userId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionNasConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionNasConfigArgsBuilder internal constructor() {
    private var groupId: Output<Int>? = null

    private var mountPoints: Output<List<V3FunctionNasConfigMountPointArgs>>? = null

    private var userId: Output<Int>? = null

    /**
     * @param value Group ID.
     */
    @JvmName("vkijdhejckuumlkd")
    public suspend fun groupId(`value`: Output<Int>) {
        this.groupId = value
    }

    /**
     * @param value Mount point list. See `mount_points` below.
     */
    @JvmName("lfefhoydfbgxsbrq")
    public suspend fun mountPoints(`value`: Output<List<V3FunctionNasConfigMountPointArgs>>) {
        this.mountPoints = value
    }

    @JvmName("rcaqlkbpeokcmpgv")
    public suspend fun mountPoints(vararg values: Output<V3FunctionNasConfigMountPointArgs>) {
        this.mountPoints = Output.all(values.asList())
    }

    /**
     * @param values Mount point list. See `mount_points` below.
     */
    @JvmName("jsxiwpingroimaok")
    public suspend fun mountPoints(values: List<Output<V3FunctionNasConfigMountPointArgs>>) {
        this.mountPoints = Output.all(values)
    }

    /**
     * @param value Account ID.
     */
    @JvmName("yvvwcenrfauocqfo")
    public suspend fun userId(`value`: Output<Int>) {
        this.userId = value
    }

    /**
     * @param value Group ID.
     */
    @JvmName("jfvurhgcjlgbbjwm")
    public suspend fun groupId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupId = mapped
    }

    /**
     * @param value Mount point list. See `mount_points` below.
     */
    @JvmName("wfsdvnuvqbbeectt")
    public suspend fun mountPoints(`value`: List<V3FunctionNasConfigMountPointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    /**
     * @param argument Mount point list. See `mount_points` below.
     */
    @JvmName("dsnivrwsikpabbie")
    public suspend fun mountPoints(argument: List<suspend V3FunctionNasConfigMountPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3FunctionNasConfigMountPointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument Mount point list. See `mount_points` below.
     */
    @JvmName("epxtwjbijcnkoouv")
    public suspend fun mountPoints(vararg argument: suspend V3FunctionNasConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3FunctionNasConfigMountPointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument Mount point list. See `mount_points` below.
     */
    @JvmName("fddnvfxfujqmiqym")
    public suspend fun mountPoints(argument: suspend V3FunctionNasConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V3FunctionNasConfigMountPointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param values Mount point list. See `mount_points` below.
     */
    @JvmName("yoipmfrutvkhguhk")
    public suspend fun mountPoints(vararg values: V3FunctionNasConfigMountPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    /**
     * @param value Account ID.
     */
    @JvmName("papssgdlruowmxvv")
    public suspend fun userId(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userId = mapped
    }

    internal fun build(): V3FunctionNasConfigArgs = V3FunctionNasConfigArgs(
        groupId = groupId,
        mountPoints = mountPoints,
        userId = userId,
    )
}
