@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigMountPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property enableTls Use transport encryption to mount. Note: only general-purpose NAS supports transmission encryption.
 * @property mountDir
 * @property serverAddr NAS server address.
 */
public data class V3FunctionNasConfigMountPointArgs(
    public val enableTls: Output<Boolean>? = null,
    public val mountDir: Output<String>? = null,
    public val serverAddr: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigMountPointArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigMountPointArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionNasConfigMountPointArgs.builder()
            .enableTls(enableTls?.applyValue({ args0 -> args0 }))
            .mountDir(mountDir?.applyValue({ args0 -> args0 }))
            .serverAddr(serverAddr?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionNasConfigMountPointArgs].
 */
@PulumiTagMarker
public class V3FunctionNasConfigMountPointArgsBuilder internal constructor() {
    private var enableTls: Output<Boolean>? = null

    private var mountDir: Output<String>? = null

    private var serverAddr: Output<String>? = null

    /**
     * @param value Use transport encryption to mount. Note: only general-purpose NAS supports transmission encryption.
     */
    @JvmName("ixlrpgxdjjdegjjs")
    public suspend fun enableTls(`value`: Output<Boolean>) {
        this.enableTls = value
    }

    /**
     * @param value
     */
    @JvmName("lbpmaxiogpyhrpff")
    public suspend fun mountDir(`value`: Output<String>) {
        this.mountDir = value
    }

    /**
     * @param value NAS server address.
     */
    @JvmName("ardjwfpdkqfdnixp")
    public suspend fun serverAddr(`value`: Output<String>) {
        this.serverAddr = value
    }

    /**
     * @param value Use transport encryption to mount. Note: only general-purpose NAS supports transmission encryption.
     */
    @JvmName("vjtfpsoffqndfdxv")
    public suspend fun enableTls(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableTls = mapped
    }

    /**
     * @param value
     */
    @JvmName("vnmffneyqfxyxcsu")
    public suspend fun mountDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountDir = mapped
    }

    /**
     * @param value NAS server address.
     */
    @JvmName("iiefvhbrrkfveufc")
    public suspend fun serverAddr(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverAddr = mapped
    }

    internal fun build(): V3FunctionNasConfigMountPointArgs = V3FunctionNasConfigMountPointArgs(
        enableTls = enableTls,
        mountDir = mountDir,
        serverAddr = serverAddr,
    )
}
