@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property mountPoints OSS mount point list. See `mount_points` below.
 */
public data class V3FunctionOssMountConfigArgs(
    public val mountPoints: Output<List<V3FunctionOssMountConfigMountPointArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigArgs.builder()
            .mountPoints(
                mountPoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [V3FunctionOssMountConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionOssMountConfigArgsBuilder internal constructor() {
    private var mountPoints: Output<List<V3FunctionOssMountConfigMountPointArgs>>? = null

    /**
     * @param value OSS mount point list. See `mount_points` below.
     */
    @JvmName("kgllcqwcgestdfal")
    public suspend fun mountPoints(`value`: Output<List<V3FunctionOssMountConfigMountPointArgs>>) {
        this.mountPoints = value
    }

    @JvmName("ippuqdxfcbnajotx")
    public suspend fun mountPoints(vararg values: Output<V3FunctionOssMountConfigMountPointArgs>) {
        this.mountPoints = Output.all(values.asList())
    }

    /**
     * @param values OSS mount point list. See `mount_points` below.
     */
    @JvmName("akhjcxmkygtmaepn")
    public suspend fun mountPoints(values: List<Output<V3FunctionOssMountConfigMountPointArgs>>) {
        this.mountPoints = Output.all(values)
    }

    /**
     * @param value OSS mount point list. See `mount_points` below.
     */
    @JvmName("tosjuxlwokgeqbtw")
    public suspend fun mountPoints(`value`: List<V3FunctionOssMountConfigMountPointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    /**
     * @param argument OSS mount point list. See `mount_points` below.
     */
    @JvmName("cihtcmjkoiqyrsyi")
    public suspend fun mountPoints(argument: List<suspend V3FunctionOssMountConfigMountPointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            V3FunctionOssMountConfigMountPointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument OSS mount point list. See `mount_points` below.
     */
    @JvmName("keyvufyfgwirybgk")
    public suspend fun mountPoints(vararg argument: suspend V3FunctionOssMountConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            V3FunctionOssMountConfigMountPointArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param argument OSS mount point list. See `mount_points` below.
     */
    @JvmName("wsnutealtflwcskg")
    public suspend fun mountPoints(argument: suspend V3FunctionOssMountConfigMountPointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            V3FunctionOssMountConfigMountPointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mountPoints = mapped
    }

    /**
     * @param values OSS mount point list. See `mount_points` below.
     */
    @JvmName("hcaxwseakmqvrobh")
    public suspend fun mountPoints(vararg values: V3FunctionOssMountConfigMountPointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mountPoints = mapped
    }

    internal fun build(): V3FunctionOssMountConfigArgs = V3FunctionOssMountConfigArgs(
        mountPoints = mountPoints,
    )
}
