@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigMountPointArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bucketName OSS Bucket name.
 * @property bucketPath Path of the mounted OSS Bucket.
 * @property endpoint OSS access endpoint.
 * @property mountDir
 * @property readOnly Read-only.
 */
public data class V3FunctionOssMountConfigMountPointArgs(
    public val bucketName: Output<String>? = null,
    public val bucketPath: Output<String>? = null,
    public val endpoint: Output<String>? = null,
    public val mountDir: Output<String>? = null,
    public val readOnly: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigMountPointArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigMountPointArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionOssMountConfigMountPointArgs.builder()
            .bucketName(bucketName?.applyValue({ args0 -> args0 }))
            .bucketPath(bucketPath?.applyValue({ args0 -> args0 }))
            .endpoint(endpoint?.applyValue({ args0 -> args0 }))
            .mountDir(mountDir?.applyValue({ args0 -> args0 }))
            .readOnly(readOnly?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [V3FunctionOssMountConfigMountPointArgs].
 */
@PulumiTagMarker
public class V3FunctionOssMountConfigMountPointArgsBuilder internal constructor() {
    private var bucketName: Output<String>? = null

    private var bucketPath: Output<String>? = null

    private var endpoint: Output<String>? = null

    private var mountDir: Output<String>? = null

    private var readOnly: Output<Boolean>? = null

    /**
     * @param value OSS Bucket name.
     */
    @JvmName("ugslqkxoricrxntu")
    public suspend fun bucketName(`value`: Output<String>) {
        this.bucketName = value
    }

    /**
     * @param value Path of the mounted OSS Bucket.
     */
    @JvmName("xsxmchcltcugelcn")
    public suspend fun bucketPath(`value`: Output<String>) {
        this.bucketPath = value
    }

    /**
     * @param value OSS access endpoint.
     */
    @JvmName("yntpvxqeepxcookl")
    public suspend fun endpoint(`value`: Output<String>) {
        this.endpoint = value
    }

    /**
     * @param value
     */
    @JvmName("pqrunanmpguprgma")
    public suspend fun mountDir(`value`: Output<String>) {
        this.mountDir = value
    }

    /**
     * @param value Read-only.
     */
    @JvmName("wkgfejppdfwbitxf")
    public suspend fun readOnly(`value`: Output<Boolean>) {
        this.readOnly = value
    }

    /**
     * @param value OSS Bucket name.
     */
    @JvmName("pfiwnaelofqktaln")
    public suspend fun bucketName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketName = mapped
    }

    /**
     * @param value Path of the mounted OSS Bucket.
     */
    @JvmName("qgodqjghrhwnjisg")
    public suspend fun bucketPath(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bucketPath = mapped
    }

    /**
     * @param value OSS access endpoint.
     */
    @JvmName("fugehnadagxiwwlx")
    public suspend fun endpoint(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpoint = mapped
    }

    /**
     * @param value
     */
    @JvmName("orpcarahebaddpis")
    public suspend fun mountDir(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mountDir = mapped
    }

    /**
     * @param value Read-only.
     */
    @JvmName("hbrivscjtamvfcxv")
    public suspend fun readOnly(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.readOnly = mapped
    }

    internal fun build(): V3FunctionOssMountConfigMountPointArgs =
        V3FunctionOssMountConfigMountPointArgs(
            bucketName = bucketName,
            bucketPath = bucketPath,
            endpoint = endpoint,
            mountDir = mountDir,
            readOnly = readOnly,
        )
}
