@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.inputs

import com.pulumi.alicloud.fc.inputs.V3FunctionVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupId Security group ID.
 * @property vpcId VPC network ID.
 * @property vswitchIds Switch List.
 */
public data class V3FunctionVpcConfigArgs(
    public val securityGroupId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
    public val vswitchIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.fc.inputs.V3FunctionVpcConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.fc.inputs.V3FunctionVpcConfigArgs =
        com.pulumi.alicloud.fc.inputs.V3FunctionVpcConfigArgs.builder()
            .securityGroupId(securityGroupId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 }))
            .vswitchIds(vswitchIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [V3FunctionVpcConfigArgs].
 */
@PulumiTagMarker
public class V3FunctionVpcConfigArgsBuilder internal constructor() {
    private var securityGroupId: Output<String>? = null

    private var vpcId: Output<String>? = null

    private var vswitchIds: Output<List<String>>? = null

    /**
     * @param value Security group ID.
     */
    @JvmName("mlyysggddtaitlti")
    public suspend fun securityGroupId(`value`: Output<String>) {
        this.securityGroupId = value
    }

    /**
     * @param value VPC network ID.
     */
    @JvmName("gccnpqlbylxjmbpa")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Switch List.
     */
    @JvmName("ddgpxgfwcxtwimua")
    public suspend fun vswitchIds(`value`: Output<List<String>>) {
        this.vswitchIds = value
    }

    @JvmName("hqflhrdawoscpyny")
    public suspend fun vswitchIds(vararg values: Output<String>) {
        this.vswitchIds = Output.all(values.asList())
    }

    /**
     * @param values Switch List.
     */
    @JvmName("wnsnigdwcfuyqjvc")
    public suspend fun vswitchIds(values: List<Output<String>>) {
        this.vswitchIds = Output.all(values)
    }

    /**
     * @param value Security group ID.
     */
    @JvmName("qpjbprmooqmveakc")
    public suspend fun securityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupId = mapped
    }

    /**
     * @param value VPC network ID.
     */
    @JvmName("hcqmkemgevqggthd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    /**
     * @param value Switch List.
     */
    @JvmName("shfapkevdkmsathy")
    public suspend fun vswitchIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    /**
     * @param values Switch List.
     */
    @JvmName("hkafbplalqbenhpy")
    public suspend fun vswitchIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vswitchIds = mapped
    }

    internal fun build(): V3FunctionVpcConfigArgs = V3FunctionVpcConfigArgs(
        securityGroupId = securityGroupId,
        vpcId = vpcId,
        vswitchIds = vswitchIds,
    )
}
