@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certName The name of the certificate, used to distinguish different certificates.
 * @property certificate Certificate data of the HTTPS certificates, follow the 'pem' format.
 * @property privateKey Private key of the HTTPS certificates, follow the 'pem' format.
 */
public data class CustomDomainCertConfig(
    public val certName: String,
    public val certificate: String,
    public val privateKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.CustomDomainCertConfig): CustomDomainCertConfig = CustomDomainCertConfig(
            certName = javaType.certName(),
            certificate = javaType.certificate(),
            privateKey = javaType.privateKey(),
        )
    }
}
