@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property functionName The name of the Function Compute function that requests are routed to.
 * @property methods The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
 * @property path The path that requests are routed from.
 * @property qualifier The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service. For detail information about version and alias, please refer to the [developer guide](https://www.alibabacloud.com/help/doc-detail/96464.htm).
 * @property serviceName The name of the Function Compute service that requests are routed to.
 */
public data class CustomDomainRouteConfig(
    public val functionName: String,
    public val methods: List<String>? = null,
    public val path: String,
    public val qualifier: String? = null,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.CustomDomainRouteConfig): CustomDomainRouteConfig = CustomDomainRouteConfig(
            functionName = javaType.functionName(),
            methods = javaType.methods().map({ args0 -> args0 }),
            path = javaType.path(),
            qualifier = javaType.qualifier().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName(),
        )
    }
}
