@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property args The args field specifies the arguments passed to the command.
 * @property command The entry point of the container, which specifies the actual command run by the container.
 * @property image The container image address.
 */
public data class FunctionCustomContainerConfig(
    public val args: String? = null,
    public val command: String? = null,
    public val image: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.FunctionCustomContainerConfig): FunctionCustomContainerConfig = FunctionCustomContainerConfig(
            args = javaType.args().map({ args0 -> args0 }).orElse(null),
            command = javaType.command().map({ args0 -> args0 }).orElse(null),
            image = javaType.image(),
        )
    }
}
