@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The account id.
 * @property apiVersion The API version of the Function Compute service.
 * @property certConfig The configuration of HTTPS certificate.
 * @property createdTime The created time of the custom domain.
 * @property domainName The custom domain name.
 * @property id The custom domain id, same as domain name.
 * @property lastModifiedTime The last modified time of the custom domain.
 * @property protocol The custom domain protocol.
 * @property routeConfigs The configuration of domain route, mapping the path and Function Compute function.
 */
public data class GetCustomDomainsDomain(
    public val accountId: String,
    public val apiVersion: String,
    public val certConfig: GetCustomDomainsDomainCertConfig,
    public val createdTime: String,
    public val domainName: String,
    public val id: String,
    public val lastModifiedTime: String,
    public val protocol: String,
    public val routeConfigs: List<GetCustomDomainsDomainRouteConfig>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetCustomDomainsDomain): GetCustomDomainsDomain = GetCustomDomainsDomain(
            accountId = javaType.accountId(),
            apiVersion = javaType.apiVersion(),
            certConfig = javaType.certConfig().let({ args0 ->
                com.pulumi.alicloud.fc.kotlin.outputs.GetCustomDomainsDomainCertConfig.Companion.toKotlin(args0)
            }),
            createdTime = javaType.createdTime(),
            domainName = javaType.domainName(),
            id = javaType.id(),
            lastModifiedTime = javaType.lastModifiedTime(),
            protocol = javaType.protocol(),
            routeConfigs = javaType.routeConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetCustomDomainsDomainRouteConfig.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
