@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property functionName The name of the Function Compute function that requests are routed to.
 * @property methods The requests of the specified HTTP methos are routed from. Valid method: GET, POST, DELETE, HEAD, PUT and PATCH. For example, "GET, HEAD" methods indicate that only requests from GET and HEAD methods are routed.
 * @property path The path that requests are routed from.
 * @property qualifier The version or alias of the Function Compute service that requests are routed to. For example, qualifier v1 indicates that the requests are routed to the version 1 Function Compute service.
 * @property serviceName The name of the Function Compute service that requests are routed to.
 */
public data class GetCustomDomainsDomainRouteConfig(
    public val functionName: String,
    public val methods: List<String>,
    public val path: String,
    public val qualifier: String,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetCustomDomainsDomainRouteConfig): GetCustomDomainsDomainRouteConfig = GetCustomDomainsDomainRouteConfig(
            functionName = javaType.functionName(),
            methods = javaType.methods().map({ args0 -> args0 }),
            path = javaType.path(),
            qualifier = javaType.qualifier(),
            serviceName = javaType.serviceName(),
        )
    }
}
