@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getCustomDomains.
 * @property domains A list of custom domains, including the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of custom domain ids.
 * @property nameRegex
 * @property names A list of custom domain names.
 * @property outputFile
 */
public data class GetCustomDomainsResult(
    public val domains: List<GetCustomDomainsDomain>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetCustomDomainsResult): GetCustomDomainsResult = GetCustomDomainsResult(
            domains = javaType.domains().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetCustomDomainsDomain.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
