@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property caPort The port that the function listen to, only valid for [custom runtime](https://www&#46;alibabacloud&#46;com/help/doc-detail/132044&#46;htm) and [custom container runtime](https://www.alibabacloud.com/help/doc-detail/179368.htm).
 * @property codeChecksum Checksum (crc64) of the function code.
 * @property codeSize Function code size in bytes.
 * @property creationTime Function creation time.
 * @property customContainerConfig The configuration for custom container runtime. It contains following attributes:
 * @property description Function description.
 * @property environmentVariables A map that defines environment variables for the function.
 * @property handler Function [entry point](https://www.alibabacloud.com/help/doc-detail/62213.htm) in the code.
 * @property id Function ID.
 * @property initializationTimeout The maximum length of time, in seconds, that the function's initialization should be run for.
 * @property initializer The entry point of the function's [initialization](https://www.alibabacloud.com/help/doc-detail/157704.htm).
 * @property instanceConcurrency The maximum number of requests can be executed concurrently within the single function instance.
 * @property instanceType The instance type of the function.
 * @property lastModificationTime Function last modification time.
 * @property memorySize Amount of memory in MB the function can use at runtime.
 * @property name Function name.
 * @property runtime Function runtime. The list of possible values is [available here](https://www.alibabacloud.com/help/doc-detail/52077.htm).
 * @property timeout Maximum amount of time the function can run in seconds.
 */
public data class GetFunctionsFunction(
    public val caPort: Int,
    public val codeChecksum: String,
    public val codeSize: Int,
    public val creationTime: String,
    public val customContainerConfig: GetFunctionsFunctionCustomContainerConfig? = null,
    public val description: String,
    public val environmentVariables: Map<String, String>,
    public val handler: String,
    public val id: String,
    public val initializationTimeout: Int,
    public val initializer: String,
    public val instanceConcurrency: Int,
    public val instanceType: String,
    public val lastModificationTime: String,
    public val memorySize: Int,
    public val name: String,
    public val runtime: String,
    public val timeout: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetFunctionsFunction): GetFunctionsFunction = GetFunctionsFunction(
            caPort = javaType.caPort(),
            codeChecksum = javaType.codeChecksum(),
            codeSize = javaType.codeSize(),
            creationTime = javaType.creationTime(),
            customContainerConfig = javaType.customContainerConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetFunctionsFunctionCustomContainerConfig.Companion.toKotlin(args0)
                })
            }).orElse(null),
            description = javaType.description(),
            environmentVariables = javaType.environmentVariables().map({ args0 ->
                args0.key.to(args0.value)
            }).toMap(),
            handler = javaType.handler(),
            id = javaType.id(),
            initializationTimeout = javaType.initializationTimeout(),
            initializer = javaType.initializer(),
            instanceConcurrency = javaType.instanceConcurrency(),
            instanceType = javaType.instanceType(),
            lastModificationTime = javaType.lastModificationTime(),
            memorySize = javaType.memorySize(),
            name = javaType.name(),
            runtime = javaType.runtime(),
            timeout = javaType.timeout(),
        )
    }
}
