@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.fc.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getServices.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of FC services ids.
 * @property nameRegex
 * @property names A list of FC services names.
 * @property outputFile
 * @property services A list of FC services. Each element contains the following attributes:
 */
public data class GetServicesResult(
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
    public val services: List<GetServicesService>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.fc.outputs.GetServicesResult): GetServicesResult = GetServicesResult(
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            services = javaType.services().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.fc.kotlin.outputs.GetServicesService.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
